/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.openshift.api.model.NamedRole;
import io.fabric8.openshift.api.model.NamedRoleBuilder;
import io.fabric8.openshift.api.model.NamedRoleFluentImpl;
import io.fabric8.openshift.api.model.Policy;
import io.fabric8.openshift.api.model.PolicyFluent;
import java.util.ArrayList;
import java.util.List;

public class PolicyFluentImpl<A extends PolicyFluent<A>>
extends BaseFluent<A>
implements PolicyFluent<A> {
    private String apiVersion;
    private String kind;
    private String lastModified;
    private VisitableBuilder<? extends ObjectMeta, ?> metadata;
    private List<VisitableBuilder<? extends NamedRole, ?>> roles = new ArrayList();

    public PolicyFluentImpl() {
    }

    public PolicyFluentImpl(Policy instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withLastModified(instance.getLastModified());
        this.withMetadata(instance.getMetadata());
        this.withRoles(instance.getRoles());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public String getLastModified() {
        return this.lastModified;
    }

    @Override
    public A withLastModified(String lastModified) {
        this.lastModified = lastModified;
        return (A)this;
    }

    @Override
    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public PolicyFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public PolicyFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public PolicyFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public PolicyFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public PolicyFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    public A addToRoles(NamedRole ... items) {
        for (NamedRole item : items) {
            NamedRoleBuilder builder = new NamedRoleBuilder(item);
            this._visitables.add(builder);
            this.roles.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromRoles(NamedRole ... items) {
        for (NamedRole item : items) {
            NamedRoleBuilder builder = new NamedRoleBuilder(item);
            this._visitables.remove(builder);
            this.roles.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<NamedRole> getRoles() {
        return PolicyFluentImpl.build(this.roles);
    }

    @Override
    public A withRoles(List<NamedRole> roles) {
        this._visitables.removeAll(this.roles);
        this.roles.clear();
        if (roles != null) {
            for (NamedRole item : roles) {
                this.addToRoles(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withRoles(NamedRole ... roles) {
        this.roles.clear();
        if (roles != null) {
            for (NamedRole item : roles) {
                this.addToRoles(item);
            }
        }
        return (A)this;
    }

    @Override
    public PolicyFluent.RolesNested<A> addNewRole() {
        return new RolesNestedImpl();
    }

    @Override
    public PolicyFluent.RolesNested<A> addNewRoleLike(NamedRole item) {
        return new RolesNestedImpl(item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PolicyFluentImpl that = (PolicyFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.lastModified != null ? !this.lastModified.equals(that.lastModified) : that.lastModified != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        return !(this.roles != null ? !this.roles.equals(that.roles) : that.roles != null);
    }

    public class RolesNestedImpl<N>
    extends NamedRoleFluentImpl<PolicyFluent.RolesNested<N>>
    implements PolicyFluent.RolesNested<N>,
    Nested<N> {
        private final NamedRoleBuilder builder;

        RolesNestedImpl(NamedRole item) {
            this.builder = new NamedRoleBuilder(this, item);
        }

        RolesNestedImpl() {
            this.builder = new NamedRoleBuilder(this);
        }

        @Override
        public N and() {
            return (N)PolicyFluentImpl.this.addToRoles(this.builder.build());
        }

        @Override
        public N endRole() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<PolicyFluent.MetadataNested<N>>
    implements PolicyFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)PolicyFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

