/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.ImageStreamSpec;
import io.fabric8.openshift.api.model.ImageStreamSpecFluent;
import io.fabric8.openshift.api.model.TagReference;
import io.fabric8.openshift.api.model.TagReferenceBuilder;
import io.fabric8.openshift.api.model.TagReferenceFluentImpl;
import java.util.ArrayList;
import java.util.List;

public class ImageStreamSpecFluentImpl<A extends ImageStreamSpecFluent<A>>
extends BaseFluent<A>
implements ImageStreamSpecFluent<A> {
    private String dockerImageRepository;
    private List<VisitableBuilder<? extends TagReference, ?>> tags = new ArrayList();

    public ImageStreamSpecFluentImpl() {
    }

    public ImageStreamSpecFluentImpl(ImageStreamSpec instance) {
        this.withDockerImageRepository(instance.getDockerImageRepository());
        this.withTags(instance.getTags());
    }

    @Override
    public String getDockerImageRepository() {
        return this.dockerImageRepository;
    }

    @Override
    public A withDockerImageRepository(String dockerImageRepository) {
        this.dockerImageRepository = dockerImageRepository;
        return (A)this;
    }

    @Override
    public A addToTags(TagReference ... items) {
        for (TagReference item : items) {
            TagReferenceBuilder builder = new TagReferenceBuilder(item);
            this._visitables.add(builder);
            this.tags.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromTags(TagReference ... items) {
        for (TagReference item : items) {
            TagReferenceBuilder builder = new TagReferenceBuilder(item);
            this._visitables.remove(builder);
            this.tags.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<TagReference> getTags() {
        return ImageStreamSpecFluentImpl.build(this.tags);
    }

    @Override
    public A withTags(List<TagReference> tags) {
        this._visitables.removeAll(this.tags);
        this.tags.clear();
        if (tags != null) {
            for (TagReference item : tags) {
                this.addToTags(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withTags(TagReference ... tags) {
        this.tags.clear();
        if (tags != null) {
            for (TagReference item : tags) {
                this.addToTags(item);
            }
        }
        return (A)this;
    }

    @Override
    public ImageStreamSpecFluent.TagsNested<A> addNewTag() {
        return new TagsNestedImpl();
    }

    @Override
    public ImageStreamSpecFluent.TagsNested<A> addNewTagLike(TagReference item) {
        return new TagsNestedImpl(item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageStreamSpecFluentImpl that = (ImageStreamSpecFluentImpl)o;
        if (this.dockerImageRepository != null ? !this.dockerImageRepository.equals(that.dockerImageRepository) : that.dockerImageRepository != null) {
            return false;
        }
        return !(this.tags != null ? !this.tags.equals(that.tags) : that.tags != null);
    }

    public class TagsNestedImpl<N>
    extends TagReferenceFluentImpl<ImageStreamSpecFluent.TagsNested<N>>
    implements ImageStreamSpecFluent.TagsNested<N>,
    Nested<N> {
        private final TagReferenceBuilder builder;

        TagsNestedImpl(TagReference item) {
            this.builder = new TagReferenceBuilder(this, item);
        }

        TagsNestedImpl() {
            this.builder = new TagReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)ImageStreamSpecFluentImpl.this.addToTags(this.builder.build());
        }

        @Override
        public N endTag() {
            return this.and();
        }
    }
}

