/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.PodSecurityContext;
import io.fabric8.kubernetes.api.model.PodSecurityContextFluent;
import io.fabric8.kubernetes.api.model.SELinuxOptions;
import io.fabric8.kubernetes.api.model.SELinuxOptionsBuilder;
import io.fabric8.kubernetes.api.model.SELinuxOptionsFluentImpl;
import java.util.ArrayList;
import java.util.List;

public class PodSecurityContextFluentImpl<A extends PodSecurityContextFluent<A>>
extends BaseFluent<A>
implements PodSecurityContextFluent<A> {
    private Long fsGroup;
    private Boolean runAsNonRoot;
    private Long runAsUser;
    private VisitableBuilder<? extends SELinuxOptions, ?> seLinuxOptions;
    private List<Long> supplementalGroups = new ArrayList<Long>();

    public PodSecurityContextFluentImpl() {
    }

    public PodSecurityContextFluentImpl(PodSecurityContext instance) {
        this.withFsGroup(instance.getFsGroup());
        this.withRunAsNonRoot(instance.getRunAsNonRoot());
        this.withRunAsUser(instance.getRunAsUser());
        this.withSeLinuxOptions(instance.getSeLinuxOptions());
        this.withSupplementalGroups(instance.getSupplementalGroups());
    }

    @Override
    public Long getFsGroup() {
        return this.fsGroup;
    }

    @Override
    public A withFsGroup(Long fsGroup) {
        this.fsGroup = fsGroup;
        return (A)this;
    }

    @Override
    public Boolean isRunAsNonRoot() {
        return this.runAsNonRoot;
    }

    @Override
    public A withRunAsNonRoot(Boolean runAsNonRoot) {
        this.runAsNonRoot = runAsNonRoot;
        return (A)this;
    }

    @Override
    public Long getRunAsUser() {
        return this.runAsUser;
    }

    @Override
    public A withRunAsUser(Long runAsUser) {
        this.runAsUser = runAsUser;
        return (A)this;
    }

    @Override
    public SELinuxOptions getSeLinuxOptions() {
        return this.seLinuxOptions != null ? (SELinuxOptions)this.seLinuxOptions.build() : null;
    }

    @Override
    public A withSeLinuxOptions(SELinuxOptions seLinuxOptions) {
        this._visitables.remove(this.seLinuxOptions);
        if (seLinuxOptions != null) {
            this.seLinuxOptions = new SELinuxOptionsBuilder(seLinuxOptions);
            this._visitables.add(this.seLinuxOptions);
        }
        return (A)this;
    }

    @Override
    public PodSecurityContextFluent.SeLinuxOptionsNested<A> withNewSeLinuxOptions() {
        return new SeLinuxOptionsNestedImpl();
    }

    @Override
    public PodSecurityContextFluent.SeLinuxOptionsNested<A> withNewSeLinuxOptionsLike(SELinuxOptions item) {
        return new SeLinuxOptionsNestedImpl(item);
    }

    @Override
    public PodSecurityContextFluent.SeLinuxOptionsNested<A> editSeLinuxOptions() {
        return this.withNewSeLinuxOptionsLike(this.getSeLinuxOptions());
    }

    @Override
    public PodSecurityContextFluent.SeLinuxOptionsNested<A> editOrNewSeLinuxOptions() {
        return this.withNewSeLinuxOptionsLike(this.getSeLinuxOptions() != null ? this.getSeLinuxOptions() : new SELinuxOptionsBuilder().build());
    }

    @Override
    public PodSecurityContextFluent.SeLinuxOptionsNested<A> editOrNewSeLinuxOptionsLike(SELinuxOptions item) {
        return this.withNewSeLinuxOptionsLike(this.getSeLinuxOptions() != null ? this.getSeLinuxOptions() : item);
    }

    @Override
    public A withNewSeLinuxOptions(String level, String role, String type, String user) {
        return this.withSeLinuxOptions(new SELinuxOptions(level, role, type, user));
    }

    @Override
    public A addToSupplementalGroups(Long ... items) {
        for (Long item : items) {
            this.supplementalGroups.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromSupplementalGroups(Long ... items) {
        for (Long item : items) {
            this.supplementalGroups.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<Long> getSupplementalGroups() {
        return this.supplementalGroups;
    }

    @Override
    public A withSupplementalGroups(List<Long> supplementalGroups) {
        this.supplementalGroups.clear();
        if (supplementalGroups != null) {
            for (Long item : supplementalGroups) {
                this.addToSupplementalGroups(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withSupplementalGroups(Long ... supplementalGroups) {
        this.supplementalGroups.clear();
        if (supplementalGroups != null) {
            for (Long item : supplementalGroups) {
                this.addToSupplementalGroups(item);
            }
        }
        return (A)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PodSecurityContextFluentImpl that = (PodSecurityContextFluentImpl)o;
        if (this.fsGroup != null ? !this.fsGroup.equals(that.fsGroup) : that.fsGroup != null) {
            return false;
        }
        if (this.runAsNonRoot != null ? !this.runAsNonRoot.equals(that.runAsNonRoot) : that.runAsNonRoot != null) {
            return false;
        }
        if (this.runAsUser != null ? !this.runAsUser.equals(that.runAsUser) : that.runAsUser != null) {
            return false;
        }
        if (this.seLinuxOptions != null ? !this.seLinuxOptions.equals(that.seLinuxOptions) : that.seLinuxOptions != null) {
            return false;
        }
        return !(this.supplementalGroups != null ? !this.supplementalGroups.equals(that.supplementalGroups) : that.supplementalGroups != null);
    }

    public class SeLinuxOptionsNestedImpl<N>
    extends SELinuxOptionsFluentImpl<PodSecurityContextFluent.SeLinuxOptionsNested<N>>
    implements PodSecurityContextFluent.SeLinuxOptionsNested<N>,
    Nested<N> {
        private final SELinuxOptionsBuilder builder;

        SeLinuxOptionsNestedImpl(SELinuxOptions item) {
            this.builder = new SELinuxOptionsBuilder(this, item);
        }

        SeLinuxOptionsNestedImpl() {
            this.builder = new SELinuxOptionsBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodSecurityContextFluentImpl.this.withSeLinuxOptions(this.builder.build());
        }

        @Override
        public N endSeLinuxOptions() {
            return this.and();
        }
    }
}

