/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.HTTPGetAction;
import io.fabric8.kubernetes.api.model.HTTPGetActionFluent;
import io.fabric8.kubernetes.api.model.HTTPHeader;
import io.fabric8.kubernetes.api.model.HTTPHeaderBuilder;
import io.fabric8.kubernetes.api.model.HTTPHeaderFluentImpl;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import io.fabric8.kubernetes.api.model.IntOrStringFluentImpl;
import java.util.ArrayList;
import java.util.List;

public class HTTPGetActionFluentImpl<A extends HTTPGetActionFluent<A>>
extends BaseFluent<A>
implements HTTPGetActionFluent<A> {
    private String host;
    private List<VisitableBuilder<? extends HTTPHeader, ?>> httpHeaders = new ArrayList();
    private String path;
    private VisitableBuilder<? extends IntOrString, ?> port;
    private String scheme;

    public HTTPGetActionFluentImpl() {
    }

    public HTTPGetActionFluentImpl(HTTPGetAction instance) {
        this.withHost(instance.getHost());
        this.withHttpHeaders(instance.getHttpHeaders());
        this.withPath(instance.getPath());
        this.withPort(instance.getPort());
        this.withScheme(instance.getScheme());
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public A withHost(String host) {
        this.host = host;
        return (A)this;
    }

    @Override
    public A addToHttpHeaders(HTTPHeader ... items) {
        for (HTTPHeader item : items) {
            HTTPHeaderBuilder builder = new HTTPHeaderBuilder(item);
            this._visitables.add(builder);
            this.httpHeaders.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromHttpHeaders(HTTPHeader ... items) {
        for (HTTPHeader item : items) {
            HTTPHeaderBuilder builder = new HTTPHeaderBuilder(item);
            this._visitables.remove(builder);
            this.httpHeaders.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<HTTPHeader> getHttpHeaders() {
        return HTTPGetActionFluentImpl.build(this.httpHeaders);
    }

    @Override
    public A withHttpHeaders(List<HTTPHeader> httpHeaders) {
        this._visitables.removeAll(this.httpHeaders);
        this.httpHeaders.clear();
        if (httpHeaders != null) {
            for (HTTPHeader item : httpHeaders) {
                this.addToHttpHeaders(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withHttpHeaders(HTTPHeader ... httpHeaders) {
        this.httpHeaders.clear();
        if (httpHeaders != null) {
            for (HTTPHeader item : httpHeaders) {
                this.addToHttpHeaders(item);
            }
        }
        return (A)this;
    }

    @Override
    public HTTPGetActionFluent.HttpHeadersNested<A> addNewHttpHeader() {
        return new HttpHeadersNestedImpl();
    }

    @Override
    public HTTPGetActionFluent.HttpHeadersNested<A> addNewHttpHeaderLike(HTTPHeader item) {
        return new HttpHeadersNestedImpl(item);
    }

    @Override
    public A addNewHttpHeader(String name, String value) {
        return this.addToHttpHeaders(new HTTPHeader(name, value));
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public A withPath(String path) {
        this.path = path;
        return (A)this;
    }

    @Override
    public IntOrString getPort() {
        return this.port != null ? (IntOrString)this.port.build() : null;
    }

    @Override
    public A withPort(IntOrString port) {
        this._visitables.remove(this.port);
        if (port != null) {
            this.port = new IntOrStringBuilder(port);
            this._visitables.add(this.port);
        }
        return (A)this;
    }

    @Override
    public HTTPGetActionFluent.PortNested<A> withNewPort() {
        return new PortNestedImpl();
    }

    @Override
    public HTTPGetActionFluent.PortNested<A> withNewPortLike(IntOrString item) {
        return new PortNestedImpl(item);
    }

    @Override
    public HTTPGetActionFluent.PortNested<A> editPort() {
        return this.withNewPortLike(this.getPort());
    }

    @Override
    public HTTPGetActionFluent.PortNested<A> editOrNewPort() {
        return this.withNewPortLike(this.getPort() != null ? this.getPort() : new IntOrStringBuilder().build());
    }

    @Override
    public HTTPGetActionFluent.PortNested<A> editOrNewPortLike(IntOrString item) {
        return this.withNewPortLike(this.getPort() != null ? this.getPort() : item);
    }

    @Override
    public A withNewPort(Integer intVal) {
        return this.withPort(new IntOrString(intVal));
    }

    @Override
    public A withNewPort(String strVal) {
        return this.withPort(new IntOrString(strVal));
    }

    @Override
    public String getScheme() {
        return this.scheme;
    }

    @Override
    public A withScheme(String scheme) {
        this.scheme = scheme;
        return (A)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HTTPGetActionFluentImpl that = (HTTPGetActionFluentImpl)o;
        if (this.host != null ? !this.host.equals(that.host) : that.host != null) {
            return false;
        }
        if (this.httpHeaders != null ? !this.httpHeaders.equals(that.httpHeaders) : that.httpHeaders != null) {
            return false;
        }
        if (this.path != null ? !this.path.equals(that.path) : that.path != null) {
            return false;
        }
        if (this.port != null ? !this.port.equals(that.port) : that.port != null) {
            return false;
        }
        return !(this.scheme != null ? !this.scheme.equals(that.scheme) : that.scheme != null);
    }

    public class PortNestedImpl<N>
    extends IntOrStringFluentImpl<HTTPGetActionFluent.PortNested<N>>
    implements HTTPGetActionFluent.PortNested<N>,
    Nested<N> {
        private final IntOrStringBuilder builder;

        PortNestedImpl(IntOrString item) {
            this.builder = new IntOrStringBuilder(this, item);
        }

        PortNestedImpl() {
            this.builder = new IntOrStringBuilder(this);
        }

        @Override
        public N and() {
            return (N)HTTPGetActionFluentImpl.this.withPort(this.builder.build());
        }

        @Override
        public N endPort() {
            return this.and();
        }
    }

    public class HttpHeadersNestedImpl<N>
    extends HTTPHeaderFluentImpl<HTTPGetActionFluent.HttpHeadersNested<N>>
    implements HTTPGetActionFluent.HttpHeadersNested<N>,
    Nested<N> {
        private final HTTPHeaderBuilder builder;

        HttpHeadersNestedImpl(HTTPHeader item) {
            this.builder = new HTTPHeaderBuilder(this, item);
        }

        HttpHeadersNestedImpl() {
            this.builder = new HTTPHeaderBuilder(this);
        }

        @Override
        public N and() {
            return (N)HTTPGetActionFluentImpl.this.addToHttpHeaders(this.builder.build());
        }

        @Override
        public N endHttpHeader() {
            return this.and();
        }
    }
}

