/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.MongoSocketOpenException;
import com.mongodb.MongoSocketReadException;
import com.mongodb.MongoSocketReadTimeoutException;
import com.mongodb.ServerAddress;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.AsyncCompletionHandler;
import com.mongodb.connection.AsyncWritableByteChannel;
import com.mongodb.connection.BufferProvider;
import com.mongodb.connection.FutureAsyncCompletionHandler;
import com.mongodb.connection.SocketSettings;
import com.mongodb.connection.Stream;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.nio.channels.InterruptedByTimeoutException;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bson.ByteBuf;

final class AsynchronousSocketChannelStream
implements Stream {
    private final ServerAddress serverAddress;
    private final SocketSettings settings;
    private final BufferProvider bufferProvider;
    private volatile AsynchronousSocketChannel channel;
    private volatile boolean isClosed;

    AsynchronousSocketChannelStream(ServerAddress serverAddress, SocketSettings settings, BufferProvider bufferProvider) {
        this.serverAddress = serverAddress;
        this.settings = settings;
        this.bufferProvider = bufferProvider;
    }

    @Override
    public ByteBuf getBuffer(int size) {
        return this.bufferProvider.getBuffer(size);
    }

    @Override
    public void open() throws IOException {
        FutureAsyncCompletionHandler<Void> handler = new FutureAsyncCompletionHandler<Void>();
        this.openAsync(handler);
        handler.getOpen();
    }

    @Override
    public void openAsync(final AsyncCompletionHandler<Void> handler) {
        Assertions.isTrue("unopened", this.channel == null);
        try {
            this.channel = AsynchronousSocketChannel.open();
            this.channel.setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, (Object)true);
            this.channel.setOption((SocketOption)StandardSocketOptions.SO_KEEPALIVE, (Object)this.settings.isKeepAlive());
            if (this.settings.getReceiveBufferSize() > 0) {
                this.channel.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)this.settings.getReceiveBufferSize());
            }
            if (this.settings.getSendBufferSize() > 0) {
                this.channel.setOption((SocketOption)StandardSocketOptions.SO_SNDBUF, (Object)this.settings.getSendBufferSize());
            }
            this.channel.connect(this.serverAddress.getSocketAddress(), null, new CompletionHandler<Void, Object>(){

                @Override
                public void completed(Void result, Object attachment) {
                    handler.completed(null);
                }

                @Override
                public void failed(Throwable exc, Object attachment) {
                    if (exc instanceof ConnectException) {
                        handler.failed(new MongoSocketOpenException("Exception opening socket", AsynchronousSocketChannelStream.this.getAddress(), exc));
                    } else {
                        handler.failed(exc);
                    }
                }
            });
        }
        catch (IOException e) {
            handler.failed(new MongoSocketOpenException("Exception opening socket", this.serverAddress, (Throwable)e));
        }
        catch (Throwable t) {
            handler.failed(t);
        }
    }

    @Override
    public void write(List<ByteBuf> buffers) throws IOException {
        FutureAsyncCompletionHandler<Void> handler = new FutureAsyncCompletionHandler<Void>();
        this.writeAsync(buffers, handler);
        handler.getWrite();
    }

    @Override
    public ByteBuf read(int numBytes) throws IOException {
        FutureAsyncCompletionHandler<ByteBuf> handler = new FutureAsyncCompletionHandler<ByteBuf>();
        this.readAsync(numBytes, handler);
        return handler.getRead();
    }

    @Override
    public void writeAsync(List<ByteBuf> buffers, final AsyncCompletionHandler<Void> handler) {
        final AsyncWritableByteChannelAdapter byteChannel = new AsyncWritableByteChannelAdapter();
        final Iterator<ByteBuf> iter = buffers.iterator();
        this.pipeOneBuffer(byteChannel, iter.next(), new AsyncCompletionHandler<Void>(){

            @Override
            public void completed(Void t) {
                if (iter.hasNext()) {
                    AsynchronousSocketChannelStream.this.pipeOneBuffer(byteChannel, (ByteBuf)iter.next(), this);
                } else {
                    handler.completed(null);
                }
            }

            @Override
            public void failed(Throwable t) {
                handler.failed(t);
            }
        });
    }

    @Override
    public void readAsync(int numBytes, AsyncCompletionHandler<ByteBuf> handler) {
        ByteBuf buffer = this.bufferProvider.getBuffer(numBytes);
        this.channel.read(buffer.asNIO(), this.settings.getReadTimeout(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS, null, new BasicCompletionHandler(buffer, handler));
    }

    @Override
    public ServerAddress getAddress() {
        return this.serverAddress;
    }

    @Override
    public void close() {
        try {
            if (this.channel != null) {
                this.channel.close();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            this.channel = null;
            this.isClosed = true;
        }
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    private void pipeOneBuffer(final AsyncWritableByteChannel byteChannel, final ByteBuf byteBuffer, final AsyncCompletionHandler<Void> outerHandler) {
        byteChannel.write(byteBuffer.asNIO(), new AsyncCompletionHandler<Void>(){

            @Override
            public void completed(Void t) {
                if (byteBuffer.hasRemaining()) {
                    byteChannel.write(byteBuffer.asNIO(), this);
                } else {
                    outerHandler.completed(null);
                }
            }

            @Override
            public void failed(Throwable t) {
                outerHandler.failed(t);
            }
        });
    }

    private final class BasicCompletionHandler
    implements CompletionHandler<Integer, Void> {
        private final ByteBuf dst;
        private final AsyncCompletionHandler<ByteBuf> handler;

        private BasicCompletionHandler(ByteBuf dst, AsyncCompletionHandler<ByteBuf> handler) {
            this.dst = dst;
            this.handler = handler;
        }

        @Override
        public void completed(Integer result, Void attachment) {
            if (result == -1) {
                this.dst.release();
                this.handler.failed(new MongoSocketReadException("Prematurely reached end of stream", AsynchronousSocketChannelStream.this.serverAddress));
            } else if (!this.dst.hasRemaining()) {
                this.dst.flip();
                this.handler.completed(this.dst);
            } else {
                AsynchronousSocketChannelStream.this.channel.read(this.dst.asNIO(), AsynchronousSocketChannelStream.this.settings.getReadTimeout(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS, null, new BasicCompletionHandler(this.dst, this.handler));
            }
        }

        @Override
        public void failed(Throwable t, Void attachment) {
            this.dst.release();
            if (t instanceof InterruptedByTimeoutException) {
                this.handler.failed(new MongoSocketReadTimeoutException("Timeout while receiving message", AsynchronousSocketChannelStream.this.serverAddress, t));
            } else {
                this.handler.failed(t);
            }
        }
    }

    private class AsyncWritableByteChannelAdapter
    implements AsyncWritableByteChannel {
        private AsyncWritableByteChannelAdapter() {
        }

        @Override
        public void write(ByteBuffer src, final AsyncCompletionHandler<Void> handler) {
            AsynchronousSocketChannelStream.this.channel.write(src, null, new CompletionHandler<Integer, Object>(){

                @Override
                public void completed(Integer result, Object attachment) {
                    handler.completed(null);
                }

                @Override
                public void failed(Throwable exc, Object attachment) {
                    handler.failed(exc);
                }
            });
        }
    }
}

