/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.util;

import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import java.util.Map;

public class AutomaticHardwareIdSpec {
    private double cores;
    private int ram;
    private Optional<Float> disk = Optional.absent();

    public static boolean isAutomaticId(String id) {
        return id.startsWith("automatic:");
    }

    public static AutomaticHardwareIdSpec parseId(String hardwareId) {
        AutomaticHardwareIdSpec spec = new AutomaticHardwareIdSpec();
        String hardwareSpec = hardwareId.substring(10);
        Map specValues = Splitter.on((char)';').trimResults().omitEmptyStrings().withKeyValueSeparator('=').split((CharSequence)hardwareSpec);
        if (!specValues.containsKey("ram") || !specValues.containsKey("cores")) {
            throw new IllegalArgumentException(String.format("Omitted keys on hardwareId: %s. Please set number of cores and ram amount.", hardwareId));
        }
        if (specValues.containsKey("disk")) {
            float disk = Float.parseFloat((String)specValues.get("disk"));
            if (disk > 0.0f) {
                spec.disk = Optional.of((Object)Float.valueOf(disk));
            } else {
                throw new IllegalArgumentException(String.format("Invalid disk value: %s", hardwareId));
            }
        }
        spec.ram = Integer.parseInt((String)specValues.get("ram"));
        spec.cores = Double.parseDouble((String)specValues.get("cores"));
        return spec;
    }

    public static AutomaticHardwareIdSpec automaticHardwareIdSpecBuilder(double cores, int ram, Optional<Float> disk) {
        AutomaticHardwareIdSpec spec = new AutomaticHardwareIdSpec();
        if (cores <= 0.0 || ram == 0) {
            throw new IllegalArgumentException(String.format("Omitted or wrong minCores and minRam. If you want to use exact values, please set the minCores and minRam values: cores=%s, ram=%s", cores, ram));
        }
        if (disk.isPresent() && ((Float)disk.get()).floatValue() <= 0.0f) {
            throw new IllegalArgumentException(String.format("Invalid disk value: %.0f", disk.get()));
        }
        spec.disk = disk;
        spec.cores = cores;
        spec.ram = ram;
        return spec;
    }

    public String toString() {
        if (this.disk.isPresent()) {
            return String.format("automatic:cores=%s;ram=%s;disk=%.0f", this.cores, this.ram, Float.valueOf(((Float)this.disk.get()).floatValue()));
        }
        return String.format("automatic:cores=%s;ram=%s", this.cores, this.ram);
    }

    public double getCores() {
        return this.cores;
    }

    public int getRam() {
        return this.ram;
    }

    public Optional<Float> getDisk() {
        return this.disk;
    }
}

