/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.domain;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.javax.annotation.Nullable;

@Beta
public class TemplateBuilderSpec {
    protected static final Splitter KEYS_SPLITTER = Splitter.on((char)',').trimResults();
    protected static final Splitter KEY_VALUE_SPLITTER = Splitter.on((char)'=').trimResults();
    protected static final ImmutableMap<String, ValueParser> VALUE_PARSERS = ImmutableMap.builder().put((Object)"hardwareId", (Object)new HardwareIdParser()).put((Object)"minCores", (Object)new MinCoresParser()).put((Object)"minRam", (Object)new MinRamParser()).put((Object)"minDisk", (Object)new MinDiskParser()).put((Object)"hypervisorMatches", (Object)new HypervisorMatchesMatchesParser()).put((Object)"imageId", (Object)new ImageIdParser()).put((Object)"imageNameMatches", (Object)new ImageNameMatchesParser()).put((Object)"osFamily", (Object)new OsFamilyParser()).put((Object)"osVersionMatches", (Object)new OsVersionMatchesParser()).put((Object)"os64Bit", (Object)new Os64BitParser()).put((Object)"osArchMatches", (Object)new OsArchMatchesParser()).put((Object)"osDescriptionMatches", (Object)new OsDescriptionMatchesParser()).put((Object)"loginUser", (Object)new LoginUserParser()).put((Object)"authenticateSudo", (Object)new AuthenticateSudoParser()).put((Object)"locationId", (Object)new LocationIdParser()).put((Object)"forceCacheReload", (Object)new ForceCacheReloadParser()).build();
    @VisibleForTesting
    String hardwareId;
    @VisibleForTesting
    Double minCores;
    @VisibleForTesting
    Integer minRam;
    @VisibleForTesting
    Double minDisk;
    @VisibleForTesting
    String hypervisorMatches;
    @VisibleForTesting
    String imageId;
    @VisibleForTesting
    String imageNameMatches;
    @VisibleForTesting
    OsFamily osFamily;
    @VisibleForTesting
    String osVersionMatches;
    @VisibleForTesting
    Boolean os64Bit;
    @VisibleForTesting
    String osArchMatches;
    @VisibleForTesting
    String osDescriptionMatches;
    @VisibleForTesting
    String loginUser;
    @VisibleForTesting
    Boolean authenticateSudo;
    @VisibleForTesting
    String locationId;
    @VisibleForTesting
    Boolean forceCacheReload;
    protected transient String specification;

    protected TemplateBuilderSpec() {
    }

    protected TemplateBuilderSpec(String specification) {
        this.specification = specification;
    }

    public static TemplateBuilderSpec parse(String templateBuilderSpecification) {
        TemplateBuilderSpec spec = new TemplateBuilderSpec(templateBuilderSpecification);
        if (!templateBuilderSpecification.isEmpty()) {
            for (String keyValuePair : KEYS_SPLITTER.split((CharSequence)templateBuilderSpecification)) {
                ImmutableList keyAndValue = ImmutableList.copyOf((Iterable)KEY_VALUE_SPLITTER.split((CharSequence)keyValuePair));
                Preconditions.checkArgument((!keyAndValue.isEmpty() ? 1 : 0) != 0, (Object)"blank key-value pair");
                Preconditions.checkArgument((keyAndValue.size() <= 2 ? 1 : 0) != 0, (String)"key-value pair %s with more than one equals sign", (Object[])new Object[]{keyValuePair});
                String key = (String)keyAndValue.get(0);
                ValueParser valueParser = (ValueParser)VALUE_PARSERS.get((Object)key);
                Preconditions.checkArgument((valueParser != null ? 1 : 0) != 0, (String)"unknown key %s", (Object[])new Object[]{key});
                String value = keyAndValue.size() == 1 ? null : (String)keyAndValue.get(1);
                valueParser.parse(spec, key, value);
            }
        }
        return spec;
    }

    public TemplateBuilder copyTo(TemplateBuilder builder, TemplateOptions templateOptions) {
        if (this.hardwareId != null) {
            builder.hardwareId(this.hardwareId);
        }
        if (this.minCores != null) {
            builder.minCores(this.minCores);
        }
        if (this.minRam != null) {
            builder.minRam(this.minRam);
        }
        if (this.minDisk != null) {
            builder.minDisk(this.minDisk);
        }
        if (this.hypervisorMatches != null) {
            builder.hypervisorMatches(this.hypervisorMatches);
        }
        if (this.imageId != null) {
            builder.imageId(this.imageId);
        }
        if (this.imageNameMatches != null) {
            builder.imageNameMatches(this.imageNameMatches);
        }
        if (this.osFamily != null) {
            builder.osFamily(this.osFamily);
        }
        if (this.osVersionMatches != null) {
            builder.osVersionMatches(this.osVersionMatches);
        }
        if (this.os64Bit != null) {
            builder.os64Bit(this.os64Bit);
        }
        if (this.osArchMatches != null) {
            builder.osArchMatches(this.osArchMatches);
        }
        if (this.osDescriptionMatches != null) {
            builder.osDescriptionMatches(this.osDescriptionMatches);
        }
        if (this.loginUser != null) {
            LoginCredentials.Builder loginBuilder = LoginCredentials.builder();
            int pos = this.loginUser.indexOf(58);
            if (pos != -1) {
                loginBuilder.user(this.loginUser.substring(0, pos)).password(this.loginUser.substring(pos + 1));
            } else {
                loginBuilder.user(this.loginUser);
            }
            if (this.authenticateSudo != null) {
                loginBuilder.authenticateSudo(this.authenticateSudo.booleanValue());
            }
            LoginCredentials creds = loginBuilder.build();
            templateOptions.overrideLoginCredentials(creds);
        }
        if (this.locationId != null) {
            builder.locationId(this.locationId);
        }
        if (this.forceCacheReload != null && this.forceCacheReload.booleanValue()) {
            builder.forceCacheReload();
        }
        return builder;
    }

    public String toParsableString() {
        return this.specification;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.toParsableString()).toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.hardwareId, this.minCores, this.minRam, this.hypervisorMatches, this.imageId, this.imageNameMatches, this.osFamily, this.osVersionMatches, this.os64Bit, this.osArchMatches, this.osDescriptionMatches, this.loginUser, this.authenticateSudo, this.locationId, this.forceCacheReload});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TemplateBuilderSpec)) {
            return false;
        }
        TemplateBuilderSpec that = (TemplateBuilderSpec)obj;
        return Objects.equal((Object)this.hardwareId, (Object)that.hardwareId) && Objects.equal((Object)this.minCores, (Object)that.minCores) && Objects.equal((Object)this.minRam, (Object)that.minRam) && Objects.equal((Object)this.hypervisorMatches, (Object)that.hypervisorMatches) && Objects.equal((Object)this.imageId, (Object)that.imageId) && Objects.equal((Object)this.imageNameMatches, (Object)that.imageNameMatches) && Objects.equal((Object)((Object)this.osFamily), (Object)((Object)that.osFamily)) && Objects.equal((Object)this.osVersionMatches, (Object)that.osVersionMatches) && Objects.equal((Object)this.os64Bit, (Object)that.os64Bit) && Objects.equal((Object)this.osArchMatches, (Object)that.osArchMatches) && Objects.equal((Object)this.osDescriptionMatches, (Object)that.osDescriptionMatches) && Objects.equal((Object)this.loginUser, (Object)that.loginUser) && Objects.equal((Object)this.authenticateSudo, (Object)that.authenticateSudo) && Objects.equal((Object)this.locationId, (Object)that.locationId) && Objects.equal((Object)this.forceCacheReload, (Object)that.forceCacheReload);
    }

    public String getHardwareId() {
        return this.hardwareId;
    }

    public Double getMinCores() {
        return this.minCores;
    }

    public Integer getMinRam() {
        return this.minRam;
    }

    public String getHypervisorMatches() {
        return this.hypervisorMatches;
    }

    public String getImageId() {
        return this.imageId;
    }

    public String getImageNameMatches() {
        return this.imageNameMatches;
    }

    public OsFamily getOsFamily() {
        return this.osFamily;
    }

    public String getOsVersionMatches() {
        return this.osVersionMatches;
    }

    public Boolean getOs64Bit() {
        return this.os64Bit;
    }

    public String getOsArchMatches() {
        return this.osArchMatches;
    }

    public String getOsDescriptionMatches() {
        return this.osDescriptionMatches;
    }

    public String getLoginUser() {
        return this.loginUser;
    }

    public Boolean getAuthenticateSudo() {
        return this.authenticateSudo;
    }

    public String getLocationId() {
        return this.locationId;
    }

    public String getSpecification() {
        return this.specification;
    }

    public Boolean getForceCacheReload() {
        return this.forceCacheReload;
    }

    static class ForceCacheReloadParser
    extends BooleanParser {
        ForceCacheReloadParser() {
        }

        @Override
        protected void parseBoolean(TemplateBuilderSpec spec, boolean value) {
            Preconditions.checkArgument((spec.forceCacheReload == null ? 1 : 0) != 0, (String)"forceCacheReload was already set to ", (Object[])new Object[]{spec.forceCacheReload});
            spec.forceCacheReload = value;
        }
    }

    static class LocationIdParser
    extends StringParser {
        LocationIdParser() {
        }

        @Override
        protected void set(TemplateBuilderSpec spec, String value) {
            Preconditions.checkArgument((spec.locationId == null ? 1 : 0) != 0, (String)"location id was already set to ", (Object[])new Object[]{spec.locationId});
            spec.locationId = value;
        }
    }

    static class AuthenticateSudoParser
    extends BooleanParser {
        AuthenticateSudoParser() {
        }

        @Override
        protected void parseBoolean(TemplateBuilderSpec spec, boolean value) {
            Preconditions.checkArgument((spec.loginUser != null ? 1 : 0) != 0, (Object)"login user must be set to use authenticateSudo");
            Preconditions.checkArgument((spec.authenticateSudo == null ? 1 : 0) != 0, (String)"authenticate sudo was already set to ", (Object[])new Object[]{spec.authenticateSudo});
            spec.authenticateSudo = value;
        }
    }

    static class LoginUserParser
    extends StringParser {
        LoginUserParser() {
        }

        @Override
        protected void set(TemplateBuilderSpec spec, String value) {
            Preconditions.checkArgument((spec.loginUser == null ? 1 : 0) != 0, (String)"login user was already set to ", (Object[])new Object[]{spec.loginUser});
            spec.loginUser = value;
        }
    }

    static class OsDescriptionMatchesParser
    extends StringParser {
        OsDescriptionMatchesParser() {
        }

        @Override
        protected void set(TemplateBuilderSpec spec, String value) {
            Preconditions.checkArgument((spec.osDescriptionMatches == null ? 1 : 0) != 0, (String)"os description matches was already set to ", (Object[])new Object[]{spec.osDescriptionMatches});
            Preconditions.checkArgument((spec.imageId == null ? 1 : 0) != 0, (String)"image id was already set to ", (Object[])new Object[]{spec.imageId});
            spec.osDescriptionMatches = value;
        }
    }

    static class OsArchMatchesParser
    extends StringParser {
        OsArchMatchesParser() {
        }

        @Override
        protected void set(TemplateBuilderSpec spec, String value) {
            Preconditions.checkArgument((spec.osArchMatches == null ? 1 : 0) != 0, (String)"os arch matches was already set to ", (Object[])new Object[]{spec.osArchMatches});
            Preconditions.checkArgument((spec.imageId == null ? 1 : 0) != 0, (String)"image id was already set to ", (Object[])new Object[]{spec.imageId});
            spec.osArchMatches = value;
        }
    }

    static class Os64BitParser
    extends BooleanParser {
        Os64BitParser() {
        }

        @Override
        protected void parseBoolean(TemplateBuilderSpec spec, boolean value) {
            Preconditions.checkArgument((spec.os64Bit == null ? 1 : 0) != 0, (String)"os 64 bit was already set to ", (Object[])new Object[]{spec.os64Bit});
            Preconditions.checkArgument((spec.imageId == null ? 1 : 0) != 0, (String)"image id was already set to ", (Object[])new Object[]{spec.imageId});
            spec.os64Bit = value;
        }
    }

    static class OsVersionMatchesParser
    extends StringParser {
        OsVersionMatchesParser() {
        }

        @Override
        protected void set(TemplateBuilderSpec spec, String value) {
            Preconditions.checkArgument((spec.osVersionMatches == null ? 1 : 0) != 0, (String)"os version matches was already set to ", (Object[])new Object[]{spec.osVersionMatches});
            Preconditions.checkArgument((spec.imageId == null ? 1 : 0) != 0, (String)"image id was already set to ", (Object[])new Object[]{spec.imageId});
            spec.osVersionMatches = value;
        }
    }

    static class OsFamilyParser
    extends EnumParser<OsFamily> {
        protected OsFamilyParser() {
            super(OsFamily.class);
        }

        @Override
        protected void parseEnum(TemplateBuilderSpec spec, OsFamily value) {
            Preconditions.checkArgument((spec.osFamily == null ? 1 : 0) != 0, (String)"operating system family was already set to ", (Object[])new Object[]{spec.osFamily});
            Preconditions.checkArgument((spec.imageId == null ? 1 : 0) != 0, (String)"image id was already set to ", (Object[])new Object[]{spec.imageId});
            spec.osFamily = value;
        }
    }

    static class ImageNameMatchesParser
    extends StringParser {
        ImageNameMatchesParser() {
        }

        @Override
        protected void set(TemplateBuilderSpec spec, String value) {
            Preconditions.checkArgument((spec.imageNameMatches == null ? 1 : 0) != 0, (String)"image name matches was already set to ", (Object[])new Object[]{spec.imageNameMatches});
            Preconditions.checkArgument((spec.imageId == null ? 1 : 0) != 0, (String)"image id was already set to ", (Object[])new Object[]{spec.imageId});
            spec.imageNameMatches = value;
        }
    }

    static class ImageIdParser
    extends StringParser {
        ImageIdParser() {
        }

        @Override
        protected void set(TemplateBuilderSpec spec, String value) {
            Preconditions.checkArgument((spec.imageId == null ? 1 : 0) != 0, (String)"image id was already set to ", (Object[])new Object[]{spec.imageId});
            Preconditions.checkArgument((spec.imageNameMatches == null ? 1 : 0) != 0, (String)"image name matches was already set to ", (Object[])new Object[]{spec.imageNameMatches});
            Preconditions.checkArgument((spec.osFamily == null ? 1 : 0) != 0, (String)"operating system family was already set to ", (Object[])new Object[]{spec.osFamily});
            Preconditions.checkArgument((spec.osVersionMatches == null ? 1 : 0) != 0, (String)"os version matches was already set to ", (Object[])new Object[]{spec.osVersionMatches});
            Preconditions.checkArgument((spec.os64Bit == null ? 1 : 0) != 0, (String)"os 64 bit was already set to ", (Object[])new Object[]{spec.os64Bit});
            Preconditions.checkArgument((spec.osArchMatches == null ? 1 : 0) != 0, (String)"os arch matches was already set to ", (Object[])new Object[]{spec.osArchMatches});
            Preconditions.checkArgument((spec.osDescriptionMatches == null ? 1 : 0) != 0, (String)"os description matches was already set to ", (Object[])new Object[]{spec.osDescriptionMatches});
            spec.imageId = value;
        }
    }

    static class HypervisorMatchesMatchesParser
    extends StringParser {
        HypervisorMatchesMatchesParser() {
        }

        @Override
        protected void set(TemplateBuilderSpec spec, String value) {
            Preconditions.checkArgument((spec.hypervisorMatches == null ? 1 : 0) != 0, (String)"hypervisor matches was already set to ", (Object[])new Object[]{spec.hypervisorMatches});
            Preconditions.checkArgument((spec.hardwareId == null ? 1 : 0) != 0, (String)"hardware id was already set to ", (Object[])new Object[]{spec.hardwareId});
            spec.hypervisorMatches = value;
        }
    }

    static class MinDiskParser
    extends DoubleParser {
        MinDiskParser() {
        }

        @Override
        protected void parseDouble(TemplateBuilderSpec spec, double value) {
            Preconditions.checkArgument((spec.minDisk == null ? 1 : 0) != 0, (String)"min disk was already set to ", (Object[])new Object[]{spec.minDisk});
            Preconditions.checkArgument((spec.hardwareId == null ? 1 : 0) != 0, (String)"hardware id was already set to ", (Object[])new Object[]{spec.hardwareId});
            spec.minDisk = value;
        }
    }

    static class MinRamParser
    extends IntegerParser {
        MinRamParser() {
        }

        @Override
        protected void parseInteger(TemplateBuilderSpec spec, int value) {
            Preconditions.checkArgument((spec.minRam == null ? 1 : 0) != 0, (String)"min ram was already set to ", (Object[])new Object[]{spec.minRam});
            Preconditions.checkArgument((spec.hardwareId == null ? 1 : 0) != 0, (String)"hardware id was already set to ", (Object[])new Object[]{spec.hardwareId});
            spec.minRam = value;
        }
    }

    static class MinCoresParser
    extends DoubleParser {
        MinCoresParser() {
        }

        @Override
        protected void parseDouble(TemplateBuilderSpec spec, double value) {
            Preconditions.checkArgument((spec.minCores == null ? 1 : 0) != 0, (String)"min cores was already set to ", (Object[])new Object[]{spec.minCores});
            Preconditions.checkArgument((spec.hardwareId == null ? 1 : 0) != 0, (String)"hardware id was already set to ", (Object[])new Object[]{spec.hardwareId});
            spec.minCores = value;
        }
    }

    static class HardwareIdParser
    extends StringParser {
        HardwareIdParser() {
        }

        @Override
        protected void set(TemplateBuilderSpec spec, String value) {
            Preconditions.checkArgument((spec.hardwareId == null ? 1 : 0) != 0, (String)"hardware id was already set to ", (Object[])new Object[]{spec.hardwareId});
            Preconditions.checkArgument((spec.minCores == null ? 1 : 0) != 0, (String)"min cores was already set to ", (Object[])new Object[]{spec.minCores});
            Preconditions.checkArgument((spec.minRam == null ? 1 : 0) != 0, (String)"min ram was already set to ", (Object[])new Object[]{spec.minRam});
            Preconditions.checkArgument((spec.hypervisorMatches == null ? 1 : 0) != 0, (String)"hypervisor matches was already set to ", (Object[])new Object[]{spec.hypervisorMatches});
            spec.hardwareId = value;
        }
    }

    static abstract class BooleanParser
    implements ValueParser {
        BooleanParser() {
        }

        protected abstract void parseBoolean(TemplateBuilderSpec var1, boolean var2);

        @Override
        public void parse(TemplateBuilderSpec spec, String key, String value) {
            Preconditions.checkArgument((value != null && !value.isEmpty() ? 1 : 0) != 0, (String)"value of key %s omitted", (Object[])new Object[]{key});
            try {
                this.parseBoolean(spec, Boolean.parseBoolean(value));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.format("key %s value set to %s, must be booleans", key, value), e);
            }
        }
    }

    static abstract class StringParser
    implements ValueParser {
        StringParser() {
        }

        protected abstract void set(TemplateBuilderSpec var1, String var2);

        @Override
        public void parse(TemplateBuilderSpec spec, String key, String value) {
            Preconditions.checkArgument((value != null && !value.isEmpty() ? 1 : 0) != 0, (String)"value of key %s omitted", (Object[])new Object[]{key});
            this.set(spec, value);
        }
    }

    static abstract class EnumParser<E extends Enum<E>>
    implements ValueParser {
        private final Class<E> type;

        protected EnumParser(Class<E> type) {
            this.type = type;
        }

        protected abstract void parseEnum(TemplateBuilderSpec var1, E var2);

        @Override
        public void parse(TemplateBuilderSpec spec, String key, String value) {
            Preconditions.checkArgument((value != null && !value.isEmpty() ? 1 : 0) != 0, (String)"value of key %s omitted", (Object[])new Object[]{key});
            try {
                this.parseEnum(spec, Enum.valueOf(this.type, value));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("key %s value set to %s, must be a name in enum %s", key, value, this.type), e);
            }
        }
    }

    static abstract class IntegerParser
    implements ValueParser {
        IntegerParser() {
        }

        protected abstract void parseInteger(TemplateBuilderSpec var1, int var2);

        @Override
        public void parse(TemplateBuilderSpec spec, String key, String value) {
            Preconditions.checkArgument((value != null && !value.isEmpty() ? 1 : 0) != 0, (String)"value of key %s omitted", (Object[])new Object[]{key});
            try {
                this.parseInteger(spec, Integer.parseInt(value));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.format("key %s value set to %s, must be integer", key, value), e);
            }
        }
    }

    static abstract class DoubleParser
    implements ValueParser {
        DoubleParser() {
        }

        protected abstract void parseDouble(TemplateBuilderSpec var1, double var2);

        @Override
        public void parse(TemplateBuilderSpec spec, String key, String value) {
            Preconditions.checkArgument((value != null && !value.isEmpty() ? 1 : 0) != 0, (String)"value of key %s omitted", (Object[])new Object[]{key});
            try {
                this.parseDouble(spec, Double.parseDouble(value));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.format("key %s value set to %s, must be double", key, value), e);
            }
        }
    }

    protected static interface ValueParser {
        public void parse(TemplateBuilderSpec var1, String var2, @Nullable String var3);
    }
}

