/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.domain;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.javax.annotation.Nullable;

@Beta
public class OperatingSystem {
    @Nullable
    protected OsFamily family;
    @Nullable
    protected String name;
    @Nullable
    protected String arch;
    @Nullable
    protected String version;
    protected String description;
    protected boolean is64Bit;

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperatingSystem that = (OperatingSystem)OperatingSystem.class.cast(o);
        return Objects.equal((Object)((Object)this.family), (Object)((Object)that.family)) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.arch, (Object)that.arch) && Objects.equal((Object)this.version, (Object)that.version) && Objects.equal((Object)this.description, (Object)that.description) && Objects.equal((Object)this.is64Bit, (Object)that.is64Bit);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.family, this.name, this.arch, this.version, this.description, this.is64Bit});
    }

    public String toString() {
        return this.string().toString();
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper((String)"").omitNullValues().add("family", (Object)this.family).add("name", (Object)this.name).add("arch", (Object)this.arch).add("version", (Object)this.version).add("description", (Object)this.description).add("is64Bit", this.is64Bit);
    }

    protected OperatingSystem() {
    }

    public OperatingSystem(@Nullable OsFamily family, @Nullable String name, @Nullable String version, @Nullable String arch, String description, boolean is64Bit) {
        this.family = family;
        this.name = name;
        this.arch = arch;
        this.version = version;
        this.description = (String)Preconditions.checkNotNull((Object)description, (Object)"description");
        this.is64Bit = is64Bit;
    }

    @Nullable
    public OsFamily getFamily() {
        return this.family;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getArch() {
        return this.arch;
    }

    @Nullable
    public String getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean is64Bit() {
        return this.is64Bit;
    }

    public Builder toBuilder() {
        return OperatingSystem.builder().fromOperatingSystem(this);
    }

    public static class Builder {
        protected OsFamily family;
        protected String name;
        protected String arch;
        protected String version;
        protected String description;
        protected boolean is64Bit;

        public Builder family(@Nullable OsFamily family) {
            this.family = family;
            return this;
        }

        public Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        public Builder arch(@Nullable String arch) {
            this.arch = arch;
            return this;
        }

        public Builder version(@Nullable String version) {
            this.version = version;
            return this;
        }

        public Builder description(String description) {
            this.description = (String)Preconditions.checkNotNull((Object)description, (Object)"description");
            return this;
        }

        public Builder is64Bit(boolean is64Bit) {
            this.is64Bit = is64Bit;
            return this;
        }

        public OperatingSystem build() {
            return new OperatingSystem(this.family, this.name, this.version, this.arch, this.description, this.is64Bit);
        }

        public Builder fromOperatingSystem(OperatingSystem in) {
            return this.family(in.getFamily()).name(in.getName()).version(in.getVersion()).arch(in.getArch()).description(in.getDescription()).is64Bit(in.is64Bit());
        }
    }
}

