/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.logback.internal;

import ch.qos.logback.classic.BasicConfigurator;
import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.joran.GenericConfigurator;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.status.WarnStatus;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.LogManager;
import org.knopflerfish.service.log.LogService;
import org.ops4j.pax.logging.EventAdminPoster;
import org.ops4j.pax.logging.PaxContext;
import org.ops4j.pax.logging.PaxLogger;
import org.ops4j.pax.logging.PaxLoggingService;
import org.ops4j.pax.logging.logback.internal.PaxLoggerImpl;
import org.ops4j.pax.logging.spi.support.BackendSupport;
import org.ops4j.pax.logging.spi.support.ConfigurationNotifier;
import org.ops4j.pax.logging.spi.support.FallbackLogFactory;
import org.ops4j.pax.logging.spi.support.LogEntryImpl;
import org.ops4j.pax.logging.spi.support.LogReaderServiceImpl;
import org.ops4j.pax.logging.spi.support.OsgiUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.log.LogEntry;
import org.slf4j.impl.StaticLoggerBinder;

public class PaxLoggingServiceImpl
implements PaxLoggingService,
LogService,
ManagedService,
ServiceFactory {
    public static final String LOGGER_CONTEXT_BUNDLECONTEXT_KEY = "org.ops4j.pax.logging.logback.bundlecontext";
    private final BundleContext m_bundleContext;
    private volatile ReadWriteLock m_configLock;
    private final LogReaderServiceImpl m_logReader;
    private final PaxContext m_paxContext;
    private final EventAdminPoster m_eventAdmin;
    private final ConfigurationNotifier m_configNotifier;
    private int m_logLevel = 4;
    private final boolean m_useStaticContext;
    private final LoggerContext m_logbackContext;
    private final String m_staticConfigFile;
    private AtomicBoolean emptyConfiguration = new AtomicBoolean(false);
    private final PaxLogger logLog;
    private final String fqcn = this.getClass().getName();

    public PaxLoggingServiceImpl(BundleContext bundleContext, LogReaderServiceImpl logReader, EventAdminPoster eventAdmin, ConfigurationNotifier configNotifier) {
        if (bundleContext == null) {
            throw new IllegalArgumentException("bundleContext cannot be null");
        }
        this.m_bundleContext = bundleContext;
        if (logReader == null) {
            throw new IllegalArgumentException("logReader cannot be null");
        }
        this.m_logReader = logReader;
        if (eventAdmin == null) {
            throw new IllegalArgumentException("eventAdmin cannot be null");
        }
        this.m_eventAdmin = eventAdmin;
        this.m_configNotifier = configNotifier;
        this.m_paxContext = new PaxContext();
        String useLocks = OsgiUtil.systemOrContextProperty(bundleContext, "org.ops4j.pax.logging.useLocks");
        if (!"false".equalsIgnoreCase(useLocks)) {
            this.m_configLock = new ReentrantReadWriteLock();
        }
        this.logLog = FallbackLogFactory.createFallbackLog(bundleContext.getBundle(), "logback");
        this.m_useStaticContext = Boolean.parseBoolean(bundleContext.getProperty("org.ops4j.pax.logging.StaticLogbackContext"));
        if (this.m_useStaticContext) {
            this.m_logbackContext = (LoggerContext)StaticLoggerBinder.getSingleton().getLoggerFactory();
        } else {
            this.m_logbackContext = new LoggerContext();
            this.m_logbackContext.start();
        }
        this.m_staticConfigFile = OsgiUtil.systemOrContextProperty(bundleContext, "org.ops4j.pax.logging.StaticLogbackFile");
        this.configureDefaults();
    }

    public void shutdown() {
        this.m_logbackContext.removeObject(LOGGER_CONTEXT_BUNDLECONTEXT_KEY);
        if (!this.m_useStaticContext) {
            this.m_logbackContext.stop();
        } else {
            this.m_logbackContext.reset();
            this.m_logbackContext.getStatusManager().add(this::logLogbackStatus);
        }
    }

    void lock(boolean useWriteLock) {
        ReadWriteLock lock = this.m_configLock;
        if (lock != null) {
            if (useWriteLock) {
                lock.writeLock().lock();
            } else {
                lock.readLock().lock();
            }
        }
    }

    void unlock(boolean useWriteLock) {
        ReadWriteLock lock = this.m_configLock;
        if (lock != null) {
            if (useWriteLock) {
                lock.writeLock().unlock();
            } else {
                lock.readLock().unlock();
            }
        }
    }

    public PaxLogger getLogger(Bundle bundle, String category, String fqcn) {
        Logger logbackLogger = category == null ? this.m_logbackContext.getLogger("ROOT") : this.m_logbackContext.getLogger(category);
        return new PaxLoggerImpl(bundle, logbackLogger, fqcn, this);
    }

    public int getLogLevel() {
        return this.m_logLevel;
    }

    public void log(int level, String message) {
        this.logImpl(null, level, message, null, this.fqcn);
    }

    public void log(int level, String message, Throwable exception) {
        this.logImpl(null, level, message, exception, this.fqcn);
    }

    public void log(ServiceReference sr, int level, String message) {
        this.logImpl(sr == null ? null : sr.getBundle(), level, message, null, this.fqcn);
    }

    public void log(ServiceReference sr, int level, String message, Throwable exception) {
        this.logImpl(sr == null ? null : sr.getBundle(), level, message, exception, this.fqcn);
    }

    public PaxContext getPaxContext() {
        return this.m_paxContext;
    }

    public void updated(Dictionary<String, ?> configuration) throws ConfigurationException {
        if (configuration == null) {
            if (this.m_staticConfigFile == null) {
                this.configureDefaults();
            }
            return;
        }
        Object useLocks = configuration.get("org.ops4j.pax.logging.useLocks");
        this.m_configLock = !"false".equalsIgnoreCase(String.valueOf(useLocks)) ? new ReentrantReadWriteLock() : null;
        Object configfile = configuration.get("org.ops4j.pax.logging.logback.config.file");
        if (this.m_staticConfigFile != null && (configfile == null || this.m_staticConfigFile.equals(configfile))) {
            return;
        }
        this.configureLogback(configfile instanceof String ? (String)configfile : null);
        this.configurePax(configuration);
        this.updateLevelsFromLog4J1Config(configuration);
    }

    private void logImpl(Bundle bundle, int level, String message, Throwable exception, String fqcn) {
        String category = BackendSupport.category(bundle);
        try {
            PaxLogger logger = this.getLogger(bundle, category, fqcn);
            if (level < 1) {
                logger.fatal(message, exception);
            } else {
                switch (level) {
                    case 1: {
                        logger.error(message, exception);
                        break;
                    }
                    case 2: {
                        logger.warn(message, exception);
                        break;
                    }
                    case 3: {
                        logger.inform(message, exception);
                        break;
                    }
                    case 4: {
                        logger.debug(message, exception);
                        break;
                    }
                    default: {
                        logger.trace(message, exception);
                    }
                }
            }
        }
        catch (RuntimeException e) {
            this.m_logbackContext.getStatusManager().add(new WarnStatus("Runtime logging failure", this.m_logbackContext, e));
        }
    }

    void handleEvents(Bundle bundle, ServiceReference sr, int level, String message, Throwable exception) {
        LogEntryImpl entry = new LogEntryImpl(bundle, sr, level, message, exception);
        this.m_logReader.fireEvent(entry);
        if (this.m_eventAdmin != null) {
            this.m_eventAdmin.postEvent(bundle, level, (LogEntry)entry, message, exception, sr, this.getPaxContext().getContext());
        }
    }

    private void configureDefaults() {
        String levelName = BackendSupport.defaultLogLevel(this.m_bundleContext);
        java.util.logging.Level julLevel = BackendSupport.toJULLevel(levelName);
        this.m_logLevel = BackendSupport.convertLogServiceLevel(levelName);
        java.util.logging.Logger rootLogger = java.util.logging.Logger.getLogger("");
        rootLogger.setLevel(julLevel);
        this.configureLogback(this.m_staticConfigFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureLogback(String configFileName) {
        Throwable problem;
        block18: {
            this.m_logbackContext.getStatusManager().clear();
            this.lock(true);
            problem = null;
            try {
                File file = null;
                if (configFileName != null) {
                    file = new File(configFileName);
                }
                if (file != null && !file.isFile()) {
                    WarnStatus warn = new WarnStatus("Configuration file '" + file + "' is not available. Default configuration will be used.", null);
                    this.m_logbackContext.getStatusManager().add(warn);
                    file = null;
                }
                if (file == null && !this.emptyConfiguration.compareAndSet(false, true)) {
                    return;
                }
                this.m_logbackContext.reset();
                this.m_logbackContext.putObject(LOGGER_CONTEXT_BUNDLECONTEXT_KEY, this.m_bundleContext);
                try {
                    ContextAwareBase configurator;
                    if (file == null) {
                        configurator = new BasicConfigurator();
                        configurator.setContext(this.m_logbackContext);
                        configurator.configure(this.m_logbackContext);
                        String level = BackendSupport.convertLogServiceLevel(this.m_logLevel);
                        Level l = Level.toLevel(level);
                        Logger rootLogger = this.m_logbackContext.getLogger("ROOT");
                        rootLogger.setLevel(l);
                        InfoStatus info = new InfoStatus("Logback configured using default configuration.", this);
                        this.m_logbackContext.getStatusManager().add(info);
                        break block18;
                    }
                    try {
                        String hostName = InetAddress.getLocalHost().getCanonicalHostName();
                        int n = hostName.indexOf(46);
                        if (n >= 0) {
                            hostName = hostName.substring(0, n);
                        }
                        this.m_logbackContext.putProperty("HOSTNAMENONCANON", hostName.toLowerCase(Locale.ENGLISH));
                    }
                    catch (UnknownHostException hostName) {
                        // empty catch block
                    }
                    configurator = new JoranConfigurator();
                    configurator.setContext(this.m_logbackContext);
                    ClassLoader tccl = Thread.currentThread().getContextClassLoader();
                    try {
                        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                        ((GenericConfigurator)configurator).doConfigure(file);
                        this.emptyConfiguration.set(false);
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(tccl);
                    }
                    InfoStatus info = new InfoStatus("Logback configured using file '" + file + "'.", this);
                    this.m_logbackContext.getStatusManager().add(info);
                }
                catch (Throwable e) {
                    ErrorStatus error = new ErrorStatus("Logback configuration problem: " + e.getMessage(), e);
                    this.m_logbackContext.getStatusManager().add(error);
                    problem = e;
                }
            }
            finally {
                this.unlock(true);
            }
        }
        this.setLevelToJavaLogging();
        if (problem == null) {
            this.m_configNotifier.configurationDone();
        } else {
            this.m_configNotifier.configurationError(problem);
        }
        this.logbackStatus();
        this.m_logbackContext.getStatusManager().clear();
        this.m_logbackContext.getStatusManager().add(this::logLogbackStatus);
    }

    private void updateLevelsFromLog4J1Config(Dictionary<String, ?> config) {
        Enumeration<String> keys = config.keys();
        while (keys.hasMoreElements()) {
            Level level;
            String name = keys.nextElement();
            if (name.equals("log4j.rootLogger")) {
                level = this.extractLevel((String)config.get(name));
                this.m_logbackContext.getLogger("ROOT").setLevel(level);
            }
            if (!name.startsWith("log4j.logger.")) continue;
            level = this.extractLevel((String)config.get(name));
            String packageName = name.substring("log4j.logger.".length());
            this.m_logbackContext.getLogger(packageName).setLevel(level);
        }
    }

    private Level extractLevel(String log4jLevelConfig) {
        String[] config = log4jLevelConfig.split("\\s*,\\s*");
        return Level.toLevel(config[0]);
    }

    private void setLevelToJavaLogging() {
        Enumeration<String> enum_ = LogManager.getLogManager().getLoggerNames();
        while (enum_.hasMoreElements()) {
            String name = enum_.nextElement();
            java.util.logging.Logger.getLogger(name).setLevel(null);
        }
        for (Logger logger : this.m_logbackContext.getLoggerList()) {
            if (logger == null) continue;
            Level l = logger.getEffectiveLevel();
            java.util.logging.Level julLevel = BackendSupport.toJULLevel(l.toString());
            if ("ROOT".equals(logger.getName()) || "".equals(logger.getName())) {
                java.util.logging.Logger.getGlobal().setLevel(julLevel);
                java.util.logging.Logger.getLogger("").setLevel(julLevel);
                java.util.logging.Logger.getLogger("global").setLevel(julLevel);
                continue;
            }
            java.util.logging.Logger.getLogger(logger.getName()).setLevel(julLevel);
        }
    }

    private void configurePax(Dictionary<String, ?> config) {
        Object size = config.get("org.ops4j.pax.logging.logReaderServiceSize");
        if (size == null) {
            size = config.get("pax.logging.entries.size");
        }
        if (null != size) {
            try {
                this.m_logReader.setMaxEntries(Integer.parseInt((String)size));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void logbackStatus() {
        StatusManager sm = this.m_logbackContext.getStatusManager();
        if (sm != null && this.logLog.isDebugEnabled()) {
            for (Status status : sm.getCopyOfStatusList()) {
                this.logLogbackStatus(status);
            }
        }
    }

    private void logLogbackStatus(Status status) {
        switch (status.getLevel()) {
            case 2: {
                this.logLog.error(status.getMessage(), status.getThrowable());
                break;
            }
            case 1: {
                this.logLog.warn(status.getMessage(), status.getThrowable());
                break;
            }
            case 0: {
                this.logLog.inform(status.getMessage(), status.getThrowable());
            }
        }
    }

    public Object getService(final Bundle bundle, ServiceRegistration registration) {
        class ManagedPaxLoggingService
        implements PaxLoggingService,
        LogService,
        ManagedService {
            private final String FQCN;

            ManagedPaxLoggingService() {
                this.FQCN = ManagedPaxLoggingService.class.getName();
            }

            public void log(int level, String message) {
                PaxLoggingServiceImpl.this.logImpl(bundle, level, message, null, this.FQCN);
            }

            public void log(int level, String message, Throwable exception) {
                PaxLoggingServiceImpl.this.logImpl(bundle, level, message, exception, this.FQCN);
            }

            public void log(ServiceReference sr, int level, String message) {
                Bundle b = bundle == null && sr != null ? sr.getBundle() : bundle;
                PaxLoggingServiceImpl.this.logImpl(b, level, message, null, this.FQCN);
            }

            public void log(ServiceReference sr, int level, String message, Throwable exception) {
                Bundle b = bundle == null && sr != null ? sr.getBundle() : bundle;
                PaxLoggingServiceImpl.this.logImpl(b, level, message, exception, this.FQCN);
            }

            public int getLogLevel() {
                return PaxLoggingServiceImpl.this.getLogLevel();
            }

            public PaxLogger getLogger(Bundle myBundle, String category, String fqcn) {
                return PaxLoggingServiceImpl.this.getLogger(myBundle, category, fqcn);
            }

            public void updated(Dictionary<String, ?> configuration) throws ConfigurationException {
                PaxLoggingServiceImpl.this.updated(configuration);
            }

            public PaxContext getPaxContext() {
                return PaxLoggingServiceImpl.this.getPaxContext();
            }
        }
        return new ManagedPaxLoggingService();
    }

    public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
    }
}

