/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.domain;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.objs.ConstraintSerialization;
import org.apache.brooklyn.rest.domain.HasName;
import org.apache.brooklyn.util.collections.Jsonya;

public class ConfigSummary
implements HasName,
Serializable {
    private static final long serialVersionUID = -2831796487073496730L;
    private final String name;
    private final String type;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final Object defaultValue;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final String description;
    @JsonSerialize
    private final boolean reconfigurable;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final String label;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final Double priority;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final List<Map<String, String>> possibleValues;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final Boolean pinned;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final List<Object> constraints;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final Map<String, URI> links;

    ConfigSummary() {
        this(null, null, null, null, false, null, null, null, null, null, null);
    }

    protected ConfigSummary(@JsonProperty(value="name") String name, @JsonProperty(value="type") String type, @JsonProperty(value="description") String description, @JsonProperty(value="defaultValue") Object defaultValue, @JsonProperty(value="reconfigurable") boolean reconfigurable, @JsonProperty(value="label") String label, @JsonProperty(value="priority") Double priority, @JsonProperty(value="possibleValues") List<Map<String, String>> possibleValues, @JsonProperty(value="pinned") Boolean pinned, @JsonProperty(value="constraints") List<?> constraints, @JsonProperty(value="links") Map<String, URI> links) {
        this.name = name;
        this.type = type;
        this.description = description;
        this.defaultValue = defaultValue;
        this.reconfigurable = reconfigurable;
        this.label = label;
        this.priority = priority;
        this.possibleValues = possibleValues;
        this.pinned = pinned;
        this.constraints = constraints == null ? ImmutableList.of() : ImmutableList.copyOf(constraints);
        this.links = links == null ? ImmutableMap.of() : ImmutableMap.copyOf(links);
    }

    public ConfigSummary(ConfigKey<?> config, String label, Double priority, Boolean pinned, Map<String, URI> links) {
        this.name = config.getName();
        this.description = config.getDescription();
        this.reconfigurable = config.isReconfigurable();
        this.label = label;
        this.priority = priority;
        this.pinned = pinned;
        this.constraints = ConstraintSerialization.INSTANCE.toJsonList(config);
        if (config.getType().isEnum()) {
            this.type = Enum.class.getName();
            this.defaultValue = config.getDefaultValue() instanceof Enum ? ((Enum)config.getDefaultValue()).name() : Jsonya.convertToJsonPrimitive((Object)config.getDefaultValue());
            this.possibleValues = FluentIterable.from(Arrays.asList((Enum[])config.getType().getEnumConstants())).transform(new Function<Enum<?>, Map<String, String>>(){

                @Nullable
                public Map<String, String> apply(@Nullable Enum<?> input) {
                    return ImmutableMap.of((Object)"value", (Object)(input != null ? input.name() : null), (Object)"description", (Object)(input != null ? input.toString() : null));
                }
            }).toList();
        } else {
            this.type = config.getTypeName();
            this.defaultValue = Jsonya.convertToJsonPrimitive((Object)config.getDefaultValue());
            this.possibleValues = null;
        }
        this.links = links == null ? ImmutableMap.of() : ImmutableMap.copyOf(links);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isReconfigurable() {
        return this.reconfigurable;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public String getLabel() {
        return this.label;
    }

    public Double getPriority() {
        return this.priority;
    }

    public List<Map<String, String>> getPossibleValues() {
        return this.possibleValues;
    }

    public Boolean isPinned() {
        return this.pinned;
    }

    public List<Object> getConstraints() {
        return this.constraints;
    }

    public Map<String, URI> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConfigSummary)) {
            return false;
        }
        ConfigSummary that = (ConfigSummary)o;
        return this.reconfigurable == that.reconfigurable && Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type) && Objects.equals(this.defaultValue, that.defaultValue) && Objects.equals(this.description, that.description) && Objects.equals(this.label, that.label) && Objects.equals(this.priority, that.priority) && Objects.equals(this.possibleValues, that.possibleValues) && Objects.equals(this.pinned, that.pinned) && Objects.equals(this.constraints, that.constraints) && Objects.equals(this.links, that.links);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.defaultValue, this.description, this.reconfigurable, this.label, this.priority, this.possibleValues, this.pinned, this.constraints);
    }

    public String toString() {
        return "ConfigSummary{name='" + this.name + '\'' + ", type='" + this.type + '\'' + ", defaultValue=" + this.defaultValue + ", description='" + this.description + '\'' + ", reconfigurable=" + this.reconfigurable + ", label='" + this.label + '\'' + ", priority=" + this.priority + ", possibleValues=" + this.possibleValues + ", pinned=" + this.pinned + ", constraints=" + this.constraints + '}';
    }
}

