/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.core.filter;

import io.swagger.core.filter.SwaggerSpecFilter;
import io.swagger.model.ApiDescription;
import io.swagger.models.Model;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Swagger;
import io.swagger.models.Tag;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.properties.Property;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SpecFilter {
    public Swagger filter(Swagger swagger, SwaggerSpecFilter filter, Map<String, List<String>> params, Map<String, String> cookies, Map<String, List<String>> headers) {
        Swagger clone = new Swagger();
        clone.info(swagger.getInfo()).tags((List)(swagger.getTags() == null ? null : new ArrayList(swagger.getTags()))).host(swagger.getHost()).basePath(swagger.getBasePath()).schemes(swagger.getSchemes()).consumes(swagger.getConsumes()).produces(swagger.getProduces()).externalDocs(swagger.getExternalDocs()).vendorExtensions(swagger.getVendorExtensions());
        HashSet filteredTags = new HashSet();
        HashSet allowedTags = new HashSet();
        for (String resourcePath : swagger.getPaths().keySet()) {
            Path path = (Path)swagger.getPaths().get(resourcePath);
            HashMap<String, Operation> ops = new HashMap<String, Operation>();
            ops.put("get", path.getGet());
            ops.put("put", path.getPut());
            ops.put("post", path.getPost());
            ops.put("delete", path.getDelete());
            ops.put("patch", path.getPatch());
            ops.put("options", path.getOptions());
            Path clonedPath = new Path();
            for (String key : ops.keySet()) {
                HashSet tags;
                Operation op = (Operation)ops.get(key);
                if (op == null) continue;
                ApiDescription desc = new ApiDescription(resourcePath, key);
                if (filter.isOperationAllowed(op, desc, params, cookies, headers)) {
                    clonedPath.set(key, this.filterOperation(filter, op, desc, params, cookies, headers));
                    tags = allowedTags;
                } else {
                    tags = filteredTags;
                }
                if (op.getTags() == null) continue;
                tags.addAll(op.getTags());
            }
            if (clonedPath.isEmpty()) continue;
            clone.path(resourcePath, clonedPath);
        }
        List tags = clone.getTags();
        filteredTags.removeAll(allowedTags);
        if (tags != null && !filteredTags.isEmpty()) {
            Iterator it = tags.iterator();
            while (it.hasNext()) {
                if (!filteredTags.contains(((Tag)it.next()).getName())) continue;
                it.remove();
            }
            if (clone.getTags().isEmpty()) {
                clone.setTags(null);
            }
        }
        Map<String, Model> definitions = this.filterDefinitions(filter, swagger.getDefinitions(), params, cookies, headers);
        clone.setSecurityDefinitions(swagger.getSecurityDefinitions());
        clone.setDefinitions(definitions);
        return clone;
    }

    public Map<String, Model> filterDefinitions(SwaggerSpecFilter filter, Map<String, Model> definitions, Map<String, List<String>> params, Map<String, String> cookies, Map<String, List<String>> headers) {
        if (definitions == null) {
            return null;
        }
        LinkedHashMap<String, Model> clonedDefinitions = new LinkedHashMap<String, Model>();
        for (String key : definitions.keySet()) {
            Model clonedModel;
            Model definition = definitions.get(key);
            LinkedHashMap<String, Property> clonedProperties = new LinkedHashMap<String, Property>();
            if (definition.getProperties() != null) {
                for (String propName : definition.getProperties().keySet()) {
                    boolean shouldInclude;
                    Property property = (Property)definition.getProperties().get(propName);
                    if (property == null || !(shouldInclude = filter.isPropertyAllowed(definition, property, propName, params, cookies, headers))) continue;
                    clonedProperties.put(propName, property);
                }
            }
            if ((clonedModel = (Model)definition.clone()).getProperties() != null) {
                clonedModel.getProperties().clear();
            }
            if (definition.getVendorExtensions() != null && clonedModel.getVendorExtensions() != null) {
                clonedModel.getVendorExtensions().putAll(definition.getVendorExtensions());
            }
            clonedModel.setProperties(clonedProperties);
            clonedDefinitions.put(key, clonedModel);
        }
        return clonedDefinitions;
    }

    public Operation filterOperation(SwaggerSpecFilter filter, Operation op, ApiDescription api, Map<String, List<String>> params, Map<String, String> cookies, Map<String, List<String>> headers) {
        Operation clonedOperation = new Operation().summary(op.getSummary()).description(op.getDescription()).operationId(op.getOperationId()).schemes(op.getSchemes()).consumes(op.getConsumes()).produces(op.getProduces()).tags(op.getTags()).externalDocs(op.getExternalDocs()).vendorExtensions(op.getVendorExtensions());
        ArrayList<Parameter> clonedParams = new ArrayList<Parameter>();
        if (op.getParameters() != null) {
            for (Parameter param : op.getParameters()) {
                if (!filter.isParamAllowed(param, op, api, params, cookies, headers)) continue;
                clonedParams.add(param);
            }
        }
        clonedOperation.setParameters(clonedParams);
        clonedOperation.setSecurity(op.getSecurity());
        clonedOperation.setResponses(op.getResponses());
        return clonedOperation;
    }
}

