/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.database.mysql;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.brooklyn.api.effector.Effector;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.core.effector.Effectors;
import org.apache.brooklyn.core.entity.EntityPredicates;
import org.apache.brooklyn.entity.database.mysql.MySqlNode;
import org.apache.brooklyn.util.core.task.DynamicTasks;

public class MySqlClusterUtils {
    protected static final Predicate<Entity> IS_MASTER = EntityPredicates.configEqualTo(MySqlNode.MYSQL_SERVER_ID, (Object)1);

    protected static String executeSqlOnNode(MySqlNode node, String commands) {
        return (String)MySqlClusterUtils.executeSqlOnNodeAsync(node, commands).getUnchecked();
    }

    protected static Task<String> executeSqlOnNodeAsync(MySqlNode node, String commands) {
        return DynamicTasks.queue((TaskAdaptable)Effectors.invocation((Entity)node, (Effector)MySqlNode.EXECUTE_SCRIPT, (Map)ImmutableMap.of((Object)"commands", (Object)commands))).asTask();
    }

    protected static String validateSqlParam(String config) {
        if (config.contains("'") && config.contains("\\")) {
            throw new IllegalStateException("User provided string contains illegal SQL characters: " + config);
        }
        return config;
    }
}

