/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.container.location.kubernetes;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.io.BaseEncoding;
import io.fabric8.kubernetes.api.model.AuthInfo;
import io.fabric8.kubernetes.api.model.Cluster;
import io.fabric8.kubernetes.api.model.Config;
import io.fabric8.kubernetes.api.model.Context;
import io.fabric8.kubernetes.api.model.NamedAuthInfo;
import io.fabric8.kubernetes.api.model.NamedCluster;
import io.fabric8.kubernetes.api.model.NamedContext;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.internal.KubeConfigUtils;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.brooklyn.container.location.kubernetes.KubernetesCerts;
import org.apache.brooklyn.container.location.kubernetes.KubernetesClientRegistry;
import org.apache.brooklyn.container.location.kubernetes.KubernetesLocationConfig;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesClientRegistryImpl
implements KubernetesClientRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesClientRegistryImpl.class);
    public static final KubernetesClientRegistryImpl INSTANCE = new KubernetesClientRegistryImpl();

    @Override
    public KubernetesClient getKubernetesClient(ConfigBag conf) {
        Duration clientTimeout;
        ConfigBuilder configBuilder = new ConfigBuilder();
        String configFile = (String)conf.get(KubernetesLocationConfig.KUBECONFIG);
        if (Strings.isNonBlank((CharSequence)configFile)) {
            try {
                Path configPath = Paths.get(configFile, new String[0]);
                Path configFolder = configPath.normalize().getParent();
                Config kubeconfig = KubeConfigUtils.parseConfig((File)configPath.toFile());
                String currentContext = (String)Optional.fromNullable((Object)conf.get(KubernetesLocationConfig.KUBECONFIG_CONTEXT)).or((Object)kubeconfig.getCurrentContext());
                Optional foundContext = Iterables.tryFind((Iterable)kubeconfig.getContexts(), c -> c.getName().equals(currentContext));
                if (!foundContext.isPresent()) {
                    throw new IllegalStateException(String.format("Context %s not found", currentContext));
                }
                Context context = ((NamedContext)foundContext.get()).getContext();
                LOG.debug("Context {} additional properties: {}", (Object)currentContext, (Object)context.getAdditionalProperties());
                configBuilder.withNamespace(context.getNamespace());
                String user = context.getUser();
                Optional foundAuthInfo = Iterables.tryFind((Iterable)kubeconfig.getUsers(), u -> u.getName().equals(user));
                if (!foundAuthInfo.isPresent()) {
                    throw new IllegalStateException(String.format("Auth info %s not found", user));
                }
                AuthInfo auth = ((NamedAuthInfo)foundAuthInfo.get()).getUser();
                LOG.debug("Auth info {} additional properties: {}", (Object)user, (Object)auth.getAdditionalProperties());
                configBuilder.withUsername(auth.getUsername());
                configBuilder.withPassword(auth.getPassword());
                if (auth.getToken() == null) {
                    if (auth.getAuthProvider() != null) {
                        configBuilder.withOauthToken((String)auth.getAuthProvider().getConfig().get("id-token"));
                    }
                } else {
                    configBuilder.withOauthToken(auth.getToken());
                }
                configBuilder.withClientCertFile(this.getRelativeFile(auth.getClientCertificate(), configFolder));
                configBuilder.withClientCertData(auth.getClientCertificateData());
                configBuilder.withClientKeyFile(this.getRelativeFile(auth.getClientKey(), configFolder));
                configBuilder.withClientKeyData(auth.getClientKeyData());
                String clusterName = context.getCluster();
                Optional foundCluster = Iterables.tryFind((Iterable)kubeconfig.getClusters(), c -> c.getName().equals(clusterName));
                if (!foundCluster.isPresent()) {
                    throw new IllegalStateException(String.format("Cluster %s not found", clusterName));
                }
                Cluster cluster = ((NamedCluster)foundCluster.get()).getCluster();
                configBuilder.withMasterUrl(cluster.getServer());
                configBuilder.withCaCertFile(this.getRelativeFile(cluster.getCertificateAuthority(), configFolder));
                configBuilder.withCaCertData(cluster.getCertificateAuthorityData());
                configBuilder.withApiVersion((String)Optional.fromNullable((Object)cluster.getApiVersion()).or((Object)"v1"));
                configBuilder.withTrustCerts(Boolean.TRUE.equals(cluster.getInsecureSkipTlsVerify()));
                LOG.debug("Cluster {} server: {}", (Object)clusterName, (Object)cluster.getServer());
                LOG.debug("Cluster {} additional properties: {}", (Object)clusterName, (Object)cluster.getAdditionalProperties());
            }
            catch (IOException e) {
                Exceptions.propagate((Throwable)e);
            }
        } else {
            String token;
            String password;
            String username;
            URL url;
            String masterUrl = (String)Preconditions.checkNotNull((Object)conf.get(KubernetesLocationConfig.MASTER_URL), (Object)"master url must not be null");
            Boolean trustCerts = (Boolean)conf.get(KubernetesLocationConfig.TRUST_CERTS);
            try {
                url = new URL(masterUrl);
            }
            catch (MalformedURLException e) {
                throw Throwables.propagate((Throwable)e);
            }
            ((ConfigBuilder)configBuilder.withMasterUrl(masterUrl)).withTrustCerts((trustCerts != null ? trustCerts : Boolean.FALSE).booleanValue());
            if (url.getProtocol().equals("https")) {
                KubernetesCerts certs = new KubernetesCerts(conf);
                if (certs.caCertData.isPresent()) {
                    configBuilder.withCaCertData(this.toBase64Encoding((String)certs.caCertData.get()));
                }
                if (certs.clientCertData.isPresent()) {
                    configBuilder.withClientCertData(this.toBase64Encoding((String)certs.clientCertData.get()));
                }
                if (certs.clientKeyData.isPresent()) {
                    configBuilder.withClientKeyData(this.toBase64Encoding((String)certs.clientKeyData.get()));
                }
                if (certs.clientKeyAlgo.isPresent()) {
                    configBuilder.withClientKeyAlgo((String)certs.clientKeyAlgo.get());
                }
                if (certs.clientKeyPassphrase.isPresent()) {
                    configBuilder.withClientKeyPassphrase((String)certs.clientKeyPassphrase.get());
                }
            }
            if (Strings.isNonBlank((CharSequence)(username = (String)conf.get(KubernetesLocationConfig.ACCESS_IDENTITY)))) {
                configBuilder.withUsername(username);
            }
            if (Strings.isNonBlank((CharSequence)(password = (String)conf.get(KubernetesLocationConfig.ACCESS_CREDENTIAL)))) {
                configBuilder.withPassword(password);
            }
            if (Strings.isNonBlank((CharSequence)(token = (String)conf.get(KubernetesLocationConfig.OAUTH_TOKEN)))) {
                configBuilder.withOauthToken(token);
            }
        }
        if (!(clientTimeout = (Duration)conf.get(KubernetesLocationConfig.CLIENT_TIMEOUT)).isPositive()) {
            throw new IllegalArgumentException("Kubernetes client timeout should be a positive duration: " + clientTimeout.toString());
        }
        configBuilder.withConnectionTimeout((int)clientTimeout.toMilliseconds());
        configBuilder.withRequestTimeout((int)clientTimeout.toMilliseconds());
        Duration actionTimeout = (Duration)conf.get(KubernetesLocationConfig.ACTION_TIMEOUT);
        if (!actionTimeout.isPositive()) {
            throw new IllegalArgumentException("Kubernetes action timeout should be a positive duration: " + actionTimeout.toString());
        }
        configBuilder.withRollingTimeout(actionTimeout.toMilliseconds());
        configBuilder.withScaleTimeout(actionTimeout.toMilliseconds());
        return new DefaultKubernetesClient(configBuilder.build());
    }

    protected String toBase64Encoding(String val) {
        return BaseEncoding.base64().encode(val.getBytes());
    }

    protected String getRelativeFile(String file, Path folder) {
        if (Strings.isBlank((CharSequence)file)) {
            return null;
        }
        Path path = Paths.get(file, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            path = folder.resolve(file);
        }
        return path.toString();
    }
}

