/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.auth.functions;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.openstack.keystone.auth.AuthenticationApi;
import org.jclouds.openstack.keystone.auth.config.CredentialType;
import org.jclouds.openstack.keystone.auth.domain.ApiAccessKeyCredentials;
import org.jclouds.openstack.keystone.auth.domain.AuthInfo;
import org.jclouds.openstack.keystone.auth.domain.TenantOrDomainAndCredentials;
import org.jclouds.openstack.keystone.auth.functions.BaseAuthenticator;

@CredentialType(value="apiAccessKeyCredentials")
@Singleton
public class AuthenticateApiAccessKeyCredentials
extends BaseAuthenticator<ApiAccessKeyCredentials> {
    private final AuthenticationApi auth;

    @Inject
    AuthenticateApiAccessKeyCredentials(AuthenticationApi auth) {
        this.auth = auth;
    }

    @Override
    public ApiAccessKeyCredentials createCredentials(String identity, String credential) {
        return ApiAccessKeyCredentials.builder().accessKey(identity).secretKey(credential).build();
    }

    @Override
    public AuthInfo authenticate(TenantOrDomainAndCredentials<ApiAccessKeyCredentials> credentials) {
        return this.auth.authenticateAccessKey(credentials);
    }
}

