/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.webapp;

import com.google.common.base.Function;
import org.apache.brooklyn.api.catalog.Catalog;
import org.apache.brooklyn.api.entity.ImplementedBy;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.core.config.render.RendererHints;
import org.apache.brooklyn.core.sensor.BasicAttributeSensor;
import org.apache.brooklyn.entity.group.DynamicCluster;
import org.apache.brooklyn.entity.webapp.DynamicWebAppClusterImpl;
import org.apache.brooklyn.entity.webapp.JavaWebAppService;
import org.apache.brooklyn.entity.webapp.WebAppService;
import org.apache.brooklyn.util.time.Duration;

@Catalog(name="Dynamic Web-app Cluster", description="A cluster of web-apps, which can be dynamically re-sized; this does not include a load-balancer")
@ImplementedBy(value=DynamicWebAppClusterImpl.class)
public interface DynamicWebAppCluster
extends DynamicCluster,
WebAppService,
JavaWebAppService,
JavaWebAppService.CanDeployAndUndeploy,
JavaWebAppService.CanRedeployAll {
    public static final AttributeSensor<Double> REQUEST_COUNT_PER_NODE = new BasicAttributeSensor(Double.class, "webapp.reqs.total.perNode", "Cluster entity request average");
    public static final AttributeSensor<Integer> ERROR_COUNT_PER_NODE = new BasicAttributeSensor(Integer.class, "webapp.reqs.errors.perNode", "Cluster entity request error average");
    public static final AttributeSensor<Double> REQUESTS_PER_SECOND_LAST_PER_NODE = new BasicAttributeSensor(Double.class, "webapp.reqs.perSec.last.perNode", "Reqs/sec (last datapoint) averaged over all nodes");
    public static final AttributeSensor<Double> REQUESTS_PER_SECOND_IN_WINDOW_PER_NODE = new BasicAttributeSensor(Double.class, "webapp.reqs.perSec.windowed.perNode", "Reqs/sec (over time window) averaged over all nodes");
    public static final AttributeSensor<Integer> TOTAL_PROCESSING_TIME_PER_NODE = ApplyDisplayHints.TOTAL_PROCESSING_TIME_PER_NODE;
    public static final AttributeSensor<Double> PROCESSING_TIME_FRACTION_IN_WINDOW_PER_NODE = new BasicAttributeSensor(Double.class, "webapp.reqs.processingTime.fraction.windowed.perNode", "Fraction of time spent processing reported by webserver (percentage, over time window) averaged over all nodes");

    public static class ApplyDisplayHints {
        public static final AttributeSensor<Integer> TOTAL_PROCESSING_TIME_PER_NODE = new BasicAttributeSensor(Integer.class, "webapp.reqs.processingTime.perNode", "Total processing time per node (millis)");

        static {
            RendererHints.register(TOTAL_PROCESSING_TIME_PER_NODE, (RendererHints.Hint)RendererHints.displayValue((Function)Duration.millisToStringRounded()));
        }
    }
}

