/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javadoc.internal.api;

import java.util.Collections;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.tools.DocumentationTool;
import javax.tools.JavaFileObject;
import org.openjdk.tools.javac.util.ClientCodeException;
import org.openjdk.tools.javac.util.Context;
import org.openjdk.tools.javadoc.internal.tool.Start;

public class JavadocTaskImpl
implements DocumentationTool.DocumentationTask {
    private final AtomicBoolean used = new AtomicBoolean();
    private final Context context;
    private Class<?> docletClass;
    private Iterable<String> options;
    private Iterable<? extends JavaFileObject> fileObjects;
    private Locale locale;

    public JavadocTaskImpl(Context context, Class<?> docletClass, Iterable<String> options, Iterable<? extends JavaFileObject> fileObjects) {
        this.context = context;
        this.docletClass = docletClass;
        this.options = options == null ? Collections.emptySet() : JavadocTaskImpl.nullCheck(options);
        this.fileObjects = fileObjects == null ? Collections.emptySet() : JavadocTaskImpl.nullCheck(fileObjects);
        this.setLocale(Locale.getDefault());
    }

    @Override
    public void setLocale(Locale locale) {
        if (this.used.get()) {
            throw new IllegalStateException();
        }
        this.locale = locale;
    }

    @Override
    public Boolean call() {
        if (!this.used.getAndSet(true)) {
            this.initContext();
            Start jdoc = new Start(this.context);
            try {
                return jdoc.begin(this.docletClass, this.options, this.fileObjects);
            }
            catch (ClientCodeException e) {
                throw new RuntimeException(e.getCause());
            }
        }
        throw new IllegalStateException("multiple calls to method 'call'");
    }

    private void initContext() {
        this.context.put(Locale.class, this.locale);
    }

    private static <T> Iterable<T> nullCheck(Iterable<T> items) {
        for (T item : items) {
            if (item != null) continue;
            throw new NullPointerException();
        }
        return items;
    }
}

