/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.util.concurrent;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.twitter.common.util.concurrent.ExceptionHandlingExecutorService;
import com.twitter.common.util.concurrent.ExceptionHandlingScheduledExecutorService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;

public final class MoreExecutors {
    private MoreExecutors() {
    }

    public static ExecutorService exceptionHandlingExecutor(ExecutorService executorService, Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        Preconditions.checkNotNull((Object)uncaughtExceptionHandler);
        return new ExceptionHandlingExecutorService(executorService, (Supplier<Thread.UncaughtExceptionHandler>)Suppliers.ofInstance((Object)uncaughtExceptionHandler));
    }

    public static ExecutorService exceptionHandlingExecutor(ExecutorService executorService) {
        return new ExceptionHandlingExecutorService(executorService, new Supplier<Thread.UncaughtExceptionHandler>(){

            public Thread.UncaughtExceptionHandler get() {
                return Thread.currentThread().getUncaughtExceptionHandler();
            }
        });
    }

    public static ScheduledExecutorService exceptionHandlingExecutor(ScheduledExecutorService executorService, Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        Preconditions.checkNotNull((Object)uncaughtExceptionHandler);
        return new ExceptionHandlingScheduledExecutorService(executorService, (Supplier<Thread.UncaughtExceptionHandler>)Suppliers.ofInstance((Object)uncaughtExceptionHandler));
    }

    public static ScheduledExecutorService exceptionHandlingExecutor(ScheduledExecutorService executorService) {
        return new ExceptionHandlingScheduledExecutorService(executorService, new Supplier<Thread.UncaughtExceptionHandler>(){

            public Thread.UncaughtExceptionHandler get() {
                return Thread.currentThread().getUncaughtExceptionHandler();
            }
        });
    }
}

