/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.stats;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.twitter.common.quantity.Amount;
import com.twitter.common.quantity.Time;
import com.twitter.common.quantity.Unit;
import com.twitter.common.stats.Statistics;
import com.twitter.common.stats.StatisticsInterface;
import com.twitter.common.stats.Windowed;
import com.twitter.common.util.Clock;

public class WindowedStatistics
extends Windowed<Statistics>
implements StatisticsInterface {
    private int lastIndex = -1;
    private double variance = 0.0;
    private double mean = 0.0;
    private long sum = 0L;
    private long min = Long.MAX_VALUE;
    private long max = Long.MIN_VALUE;
    private long populationSize = 0L;

    public WindowedStatistics(Amount<Long, Time> amount, int n, Clock clock) {
        super(Statistics.class, amount, n, new Supplier<Statistics>(){

            public Statistics get() {
                return new Statistics();
            }
        }, new Function<Statistics, Statistics>(){

            public Statistics apply(Statistics statistics) {
                statistics.clear();
                return statistics;
            }
        }, clock);
    }

    public WindowedStatistics(Amount<Long, Time> amount, int n) {
        this(amount, n, Clock.SYSTEM_CLOCK);
    }

    public WindowedStatistics() {
        this((Amount<Long, Time>)Amount.of((long)1L, (Unit)Time.MINUTES), 3, Clock.SYSTEM_CLOCK);
    }

    @Override
    public void accumulate(long l) {
        ((Statistics)this.getCurrent()).accumulate(l);
    }

    public void refresh() {
        int n = this.getCurrentIndex();
        if (this.lastIndex != n) {
            this.lastIndex = n;
            double d = 0.0;
            this.variance = 0.0;
            this.mean = 0.0;
            this.sum = 0L;
            this.populationSize = 0L;
            this.min = Long.MAX_VALUE;
            this.max = Long.MIN_VALUE;
            for (Statistics statistics : (Statistics[])this.getTenured()) {
                if (statistics.populationSize() == 0L) continue;
                d += (double)statistics.populationSize() * (statistics.variance() + statistics.mean() * statistics.mean());
                this.sum += statistics.sum();
                this.populationSize += statistics.populationSize();
                this.min = Math.min(this.min, statistics.min());
                this.max = Math.max(this.max, statistics.max());
            }
            if (this.populationSize != 0L) {
                this.mean = (double)this.sum / (double)this.populationSize;
                this.variance = d / (double)this.populationSize - this.mean * this.mean;
            }
        }
    }

    @Override
    public double variance() {
        return this.variance;
    }

    @Override
    public double standardDeviation() {
        return Math.sqrt(this.variance());
    }

    @Override
    public double mean() {
        return this.mean;
    }

    @Override
    public long sum() {
        return this.sum;
    }

    @Override
    public long min() {
        return this.min;
    }

    @Override
    public long max() {
        return this.max;
    }

    @Override
    public long range() {
        return this.max - this.min;
    }

    @Override
    public long populationSize() {
        return this.populationSize;
    }
}

