/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.stats;

import com.google.common.base.Preconditions;
import com.twitter.common.util.Random;
import java.util.Vector;

public class ReservoirSampler<T> {
    private final Vector<T> reservoir = new Vector();
    private final int numSamples;
    private final Random random;
    private int numItemsSeen = 0;

    public ReservoirSampler(int n, Random random) {
        Preconditions.checkArgument((n > 0 ? 1 : 0) != 0, (Object)"numSamples should be positive");
        Preconditions.checkNotNull((Object)random);
        this.numSamples = n;
        this.random = random;
    }

    public ReservoirSampler(int n) {
        this(n, Random.Util.newDefaultRandom());
    }

    public void sample(T t) {
        Preconditions.checkNotNull(t);
        if (this.reservoir.size() < this.numSamples) {
            this.reservoir.add(t);
        } else {
            int n = this.random.nextInt(this.numItemsSeen + 1);
            if (n < this.numSamples) {
                this.reservoir.set(n, t);
            }
        }
        ++this.numItemsSeen;
    }

    public Iterable<T> getSamples() {
        return this.reservoir;
    }
}

