/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.generators.core;

import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;

public class Paddings {
    private static final Map<String, String> PADDING_CACHE = Collections.synchronizedMap(new HashMap());

    private static String generate(String prefix) {
        if (prefix.isEmpty()) {
            throw new IllegalArgumentException("prefix must not be empty");
        }
        StringJoiner sj = new StringJoiner("");
        for (int p = 0; p < 16; ++p) {
            sj.add("    byte ");
            for (int q = 0; q < 16; ++q) {
                if (q != 0) {
                    sj.add(", ");
                }
                sj.add(prefix);
                sj.add(String.format("%03d", p * 16 + q));
            }
            sj.add(";");
            sj.add(System.lineSeparator());
        }
        return sj.toString();
    }

    public static void padding(PrintWriter writer, String prefix) {
        writer.print(PADDING_CACHE.computeIfAbsent(prefix, Paddings::generate));
    }
}

