/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.statement;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.metadata.Namespace;
import org.apache.asterix.lang.common.base.AbstractStatement;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.IReturningStatement;
import org.apache.asterix.lang.common.base.Statement;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.statement.Query;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;

public class InsertStatement
extends AbstractStatement
implements IReturningStatement {
    private Namespace namespace;
    private String datasetName;
    private final Query query;
    private final VariableExpr var;
    private Expression returnExpression;
    private int varCounter;

    public InsertStatement(Namespace namespace, String datasetName, Query query, int varCounter, VariableExpr var, Expression returnExpression) {
        this.namespace = namespace;
        this.datasetName = datasetName;
        this.query = query;
        this.varCounter = varCounter;
        this.var = var;
        this.returnExpression = returnExpression;
    }

    @Override
    public Statement.Kind getKind() {
        return Statement.Kind.INSERT;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public DataverseName getDataverseName() {
        return this.namespace == null ? null : this.namespace.getDataverseName();
    }

    public String getDatabaseName() {
        return this.namespace == null ? null : this.namespace.getDatabaseName();
    }

    public void setNamespace(Namespace namespace) {
        this.namespace = namespace;
    }

    public String getDatasetName() {
        return this.datasetName;
    }

    public void setDatasetName(String datasetName) {
        this.datasetName = datasetName;
    }

    public Query getQuery() {
        return this.query;
    }

    @Override
    public int getVarCounter() {
        return this.varCounter;
    }

    @Override
    public void setVarCounter(int varCounter) {
        this.varCounter = varCounter;
    }

    @Override
    public List<Expression> getDirectlyEnclosedExpressions() {
        ArrayList<Expression> topLevelExpressions = new ArrayList<Expression>();
        topLevelExpressions.add(this.query.getBody());
        if (this.returnExpression != null) {
            topLevelExpressions.add(this.returnExpression);
        }
        return topLevelExpressions;
    }

    @Override
    public boolean isTopLevel() {
        return true;
    }

    @Override
    public Expression getBody() {
        return this.query.getBody();
    }

    @Override
    public void setBody(Expression body) {
        this.query.setBody(body);
    }

    public VariableExpr getVar() {
        return this.var;
    }

    public Expression getReturnExpression() {
        return this.returnExpression;
    }

    public void setReturnExpression(Expression expr) {
        this.returnExpression = expr;
    }

    @Override
    public <R, T> R accept(ILangVisitor<R, T> visitor, T arg) throws CompilationException {
        return visitor.visit(this, arg);
    }

    public int hashCode() {
        return Objects.hash(this.datasetName, this.namespace, this.query, this.varCounter, this.var, this.returnExpression);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof InsertStatement)) {
            return false;
        }
        InsertStatement target = (InsertStatement)object;
        return Objects.equals(this.datasetName, target.datasetName) && Objects.equals(this.namespace, target.namespace) && Objects.equals(this.query, target.query) && Objects.equals(this.returnExpression, target.returnExpression) && this.varCounter == target.varCounter && Objects.equals(this.var, target.var);
    }

    @Override
    public byte getCategory() {
        return 2;
    }
}

