/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.pushdown.schema;

import org.apache.asterix.optimizer.rules.pushdown.schema.AbstractExpectedSchemaNode;
import org.apache.asterix.optimizer.rules.pushdown.schema.AnyExpectedSchemaNode;
import org.apache.asterix.optimizer.rules.pushdown.schema.ArrayExpectedSchemaNode;
import org.apache.asterix.optimizer.rules.pushdown.schema.ExpectedSchemaNodeType;
import org.apache.asterix.optimizer.rules.pushdown.schema.IExpectedSchemaNode;
import org.apache.asterix.optimizer.rules.pushdown.schema.ObjectExpectedSchemaNode;
import org.apache.asterix.optimizer.rules.pushdown.schema.UnionExpectedSchemaNode;
import org.apache.hyracks.api.exceptions.SourceLocation;

public abstract class AbstractComplexExpectedSchemaNode
extends AbstractExpectedSchemaNode {
    AbstractComplexExpectedSchemaNode(AbstractComplexExpectedSchemaNode parent, SourceLocation sourceLocation, String functionName) {
        super(parent, sourceLocation, functionName);
    }

    @Override
    public boolean allowsReplacing() {
        return true;
    }

    @Override
    public IExpectedSchemaNode replaceIfNeeded(ExpectedSchemaNodeType expectedNodeType, SourceLocation sourceLocation, String functionName) {
        AbstractExpectedSchemaNode node = this;
        if (expectedNodeType == ExpectedSchemaNodeType.ANY) {
            node = new AnyExpectedSchemaNode(this.getParent(), this.getSourceLocation(), this.getFunctionName(), false);
            this.getParent().replaceChild(this, node);
        } else if (expectedNodeType != this.getType()) {
            UnionExpectedSchemaNode unionSchemaNode = new UnionExpectedSchemaNode(this.getParent(), this.getSourceLocation(), this.getFunctionName());
            unionSchemaNode.addChild(this);
            this.getParent().replaceChild(this, unionSchemaNode);
            this.setParent(unionSchemaNode);
            unionSchemaNode.createChild(expectedNodeType, sourceLocation, functionName);
            node = unionSchemaNode;
        }
        return node;
    }

    protected abstract void replaceChild(IExpectedSchemaNode var1, IExpectedSchemaNode var2);

    public static AbstractComplexExpectedSchemaNode createNestedNode(ExpectedSchemaNodeType type, AbstractComplexExpectedSchemaNode parent, SourceLocation sourceLocation, String functionName) {
        switch (type) {
            case ARRAY: {
                return new ArrayExpectedSchemaNode(parent, sourceLocation, functionName);
            }
            case OBJECT: {
                return new ObjectExpectedSchemaNode(parent, sourceLocation, functionName);
            }
            case UNION: {
                return new UnionExpectedSchemaNode(parent, sourceLocation, functionName);
            }
        }
        throw new IllegalStateException(type + " is not nested or unknown");
    }
}

