/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.file;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.IOperatorNodePushable;
import org.apache.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileSplit;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.api.util.ExceptionUtils;
import org.apache.hyracks.dataflow.std.base.AbstractOperatorNodePushable;
import org.apache.hyracks.dataflow.std.base.AbstractSingleActivityOperatorDescriptor;
import org.apache.hyracks.dataflow.std.file.IFileSplitProvider;

public class FileRemoveOperatorDescriptor
extends AbstractSingleActivityOperatorDescriptor {
    private static final long serialVersionUID = 2L;
    private final IFileSplitProvider fileSplitProvider;
    private final boolean quietly;
    private final int[][] partitionsMap;

    public FileRemoveOperatorDescriptor(IOperatorDescriptorRegistry spec, IFileSplitProvider fileSplitProvder, boolean quietly, int[][] partitionsMap) {
        super(spec, 0, 0);
        this.fileSplitProvider = fileSplitProvder;
        this.quietly = quietly;
        this.partitionsMap = partitionsMap;
    }

    public IOperatorNodePushable createPushRuntime(IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, int partition, int nPartitions) throws HyracksDataException {
        final FileSplit[] splits = this.fileSplitProvider.getFileSplits();
        final int[] splitsIndexes = this.partitionsMap[partition];
        final IIOManager ioManager = ctx.getIoManager();
        return new AbstractOperatorNodePushable(){

            public void setOutputFrameWriter(int index, IFrameWriter writer, RecordDescriptor recordDesc) {
                throw new IllegalStateException();
            }

            public void initialize() throws HyracksDataException {
                this.deleteFiles();
            }

            public IFrameWriter getInputFrameWriter(int index) {
                throw new IllegalStateException();
            }

            public int getInputArity() {
                return 0;
            }

            public void deinitialize() throws HyracksDataException {
            }

            private void deleteFiles() throws HyracksDataException {
                Throwable failure = null;
                for (int splitsIndex : splitsIndexes) {
                    try {
                        File file = splits[splitsIndex].getFile(ioManager);
                        if (FileRemoveOperatorDescriptor.this.quietly) {
                            FileUtils.deleteQuietly((File)file);
                            continue;
                        }
                        FileUtils.deleteDirectory((File)file);
                    }
                    catch (Throwable th) {
                        failure = ExceptionUtils.suppress(failure, (Throwable)th);
                    }
                }
                if (failure != null) {
                    throw HyracksDataException.create(failure);
                }
            }
        };
    }
}

