/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.assembler;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.asterix.column.assembler.AbstractNestedValueAssembler;
import org.apache.asterix.column.assembler.AbstractPrimitiveValueAssembler;
import org.apache.asterix.column.assembler.AbstractValueAssembler;
import org.apache.asterix.column.assembler.ArrayValueAssembler;
import org.apache.asterix.column.assembler.ArrayWithUnionValueAssembler;
import org.apache.asterix.column.assembler.AssemblerInfo;
import org.apache.asterix.column.assembler.EmptyAssembler;
import org.apache.asterix.column.assembler.EndOfRepeatedGroupAssembler;
import org.apache.asterix.column.assembler.ObjectValueAssembler;
import org.apache.asterix.column.assembler.PrimitiveValueAssembler;
import org.apache.asterix.column.assembler.RepeatedPrimitiveValueAssembler;
import org.apache.asterix.column.assembler.value.IValueGetter;
import org.apache.asterix.column.assembler.value.IValueGetterFactory;
import org.apache.asterix.column.metadata.schema.AbstractSchemaNode;
import org.apache.asterix.column.metadata.schema.ISchemaNodeVisitor;
import org.apache.asterix.column.metadata.schema.ObjectSchemaNode;
import org.apache.asterix.column.metadata.schema.UnionSchemaNode;
import org.apache.asterix.column.metadata.schema.collection.AbstractCollectionSchemaNode;
import org.apache.asterix.column.metadata.schema.primitive.PrimitiveSchemaNode;
import org.apache.asterix.column.operation.query.QueryColumnMetadata;
import org.apache.asterix.column.values.IColumnValuesReader;
import org.apache.asterix.column.values.IColumnValuesReaderFactory;
import org.apache.asterix.column.values.reader.PrimitiveColumnValuesReader;
import org.apache.asterix.om.pointables.base.DefaultOpenFieldType;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;

public class AssemblerBuilderVisitor
implements ISchemaNodeVisitor<AbstractValueAssembler, AssemblerInfo> {
    private static final BitSet NO_DECLARED_FIELDS = new BitSet(0);
    private final QueryColumnMetadata columnMetadata;
    private final IColumnValuesReaderFactory readerFactory;
    private final List<AbstractPrimitiveValueAssembler> valueAssemblers;
    private final IValueGetterFactory valueGetterFactory;
    private final Map<Integer, IColumnValuesReader> primaryKeyReaders;
    private AbstractValueAssembler rootAssembler;
    private final IntList delimiters;
    private RepeatedPrimitiveValueAssembler delegateAssembler;
    private int level;

    public AssemblerBuilderVisitor(QueryColumnMetadata columnMetadata, IColumnValuesReaderFactory readerFactory, IValueGetterFactory valueGetterFactory) {
        this.columnMetadata = columnMetadata;
        this.readerFactory = readerFactory;
        this.valueGetterFactory = valueGetterFactory;
        this.valueAssemblers = new ArrayList<AbstractPrimitiveValueAssembler>();
        this.delimiters = new IntArrayList();
        this.primaryKeyReaders = new HashMap<Integer, IColumnValuesReader>();
        for (PrimitiveColumnValuesReader reader : columnMetadata.getPrimaryKeyReaders()) {
            this.primaryKeyReaders.put(reader.getColumnIndex(), reader);
        }
    }

    public AbstractPrimitiveValueAssembler[] createValueAssemblers(AbstractSchemaNode requestedSchema, ARecordType declaredType) throws HyracksDataException {
        EmptyAssembler root = new EmptyAssembler();
        AssemblerInfo info = new AssemblerInfo((IAType)declaredType, root);
        this.level = 0;
        this.rootAssembler = requestedSchema.accept(this, info);
        return this.valueAssemblers.toArray(new AbstractPrimitiveValueAssembler[0]);
    }

    public AbstractValueAssembler getRootAssembler() {
        return this.rootAssembler;
    }

    @Override
    public AbstractValueAssembler visit(ObjectSchemaNode objectNode, AssemblerInfo info) throws HyracksDataException {
        ObjectValueAssembler objectAssembler = new ObjectValueAssembler(this.level, info);
        ++this.level;
        BitSet declaredFields = this.handleDeclaredFields(objectNode, info, objectAssembler);
        IntList childrenFieldNameIndexes = objectNode.getChildrenFieldNameIndexes();
        int numberOfAddedChildren = declaredFields.cardinality();
        if (numberOfAddedChildren < childrenFieldNameIndexes.size()) {
            for (int i = 0; i < childrenFieldNameIndexes.size(); ++i) {
                int fieldNameIdx = childrenFieldNameIndexes.getInt(i);
                AbstractSchemaNode childNode = objectNode.getChild(fieldNameIdx);
                if (fieldNameIdx != -1 && declaredFields.get(fieldNameIdx)) continue;
                IAType childType = this.getChildType(childNode, (IAType)BuiltinType.ANY);
                IValueReference fieldName = this.columnMetadata.getFieldNamesDictionary().getFieldName(fieldNameIdx);
                boolean delegate = ++numberOfAddedChildren == childrenFieldNameIndexes.size();
                AssemblerInfo childInfo = new AssemblerInfo(childType, (AbstractNestedValueAssembler)objectAssembler, delegate, fieldName);
                childNode.accept(this, childInfo);
            }
        }
        --this.level;
        return objectAssembler;
    }

    private BitSet handleDeclaredFields(ObjectSchemaNode objectNode, AssemblerInfo info, ObjectValueAssembler objectAssembler) throws HyracksDataException {
        ARecordType declaredType = (ARecordType)info.getDeclaredType();
        if (declaredType == DefaultOpenFieldType.NESTED_OPEN_RECORD_TYPE) {
            return NO_DECLARED_FIELDS;
        }
        BitSet processedFields = new BitSet();
        String[] declaredFieldNames = declaredType.getFieldNames();
        IAType[] declaredFieldTypes = declaredType.getFieldTypes();
        int addedChildren = 0;
        int requestedChildren = objectNode.getChildren().size();
        for (int i = 0; i < declaredFieldTypes.length; ++i) {
            String fieldName = declaredFieldNames[i];
            int fieldNameIndex = this.columnMetadata.getFieldNamesDictionary().getFieldNameIndex(fieldName);
            AbstractSchemaNode childNode = objectNode.getChild(fieldNameIndex);
            if (childNode.getTypeTag() == ATypeTag.MISSING) continue;
            IAType childType = this.getChildType(childNode, declaredFieldTypes[i]);
            processedFields.set(fieldNameIndex);
            boolean delegate = ++addedChildren == requestedChildren;
            AssemblerInfo childInfo = new AssemblerInfo(childType, (AbstractNestedValueAssembler)objectAssembler, delegate, i);
            childNode.accept(this, childInfo);
        }
        return processedFields;
    }

    @Override
    public AbstractValueAssembler visit(AbstractCollectionSchemaNode collectionNode, AssemblerInfo info) throws HyracksDataException {
        AbstractCollectionType declaredType = (AbstractCollectionType)info.getDeclaredType();
        AbstractSchemaNode itemNode = collectionNode.getItemNode();
        ArrayValueAssembler arrayAssembler = itemNode.getTypeTag() == ATypeTag.UNION ? new ArrayWithUnionValueAssembler(this.level, info, this.valueAssemblers.size(), itemNode) : new ArrayValueAssembler(this.level, info, this.valueAssemblers.size());
        this.delimiters.add(this.level - 1);
        ++this.level;
        RepeatedPrimitiveValueAssembler previousDelegate = this.delegateAssembler;
        this.delegateAssembler = null;
        IAType itemDeclaredType = this.getChildType(itemNode, declaredType.getItemType());
        AssemblerInfo itemInfo = new AssemblerInfo(itemDeclaredType, arrayAssembler, false);
        itemNode.accept(this, itemInfo);
        if (this.delegateAssembler != null) {
            this.delegateAssembler.setAsDelegate(this.level - 1);
            IColumnValuesReader reader = this.delegateAssembler.getReader();
            int numberOfDelimiters = reader.getNumberOfDelimiters();
            EndOfRepeatedGroupAssembler endOfGroupAssembler = new EndOfRepeatedGroupAssembler(reader, arrayAssembler, numberOfDelimiters - this.delimiters.size());
            this.valueAssemblers.add(endOfGroupAssembler);
        }
        --this.level;
        this.delimiters.removeInt(this.delimiters.size() - 1);
        if (previousDelegate != null && !this.delimiters.isEmpty()) {
            this.delegateAssembler = previousDelegate;
        }
        return arrayAssembler;
    }

    @Override
    public AbstractValueAssembler visit(UnionSchemaNode unionNode, AssemblerInfo info) throws HyracksDataException {
        Collection<AbstractSchemaNode> children = unionNode.getChildren().values();
        int index = 0;
        for (AbstractSchemaNode node : children) {
            IAType unionDeclaredType = this.getChildType(node, info.getDeclaredType());
            boolean delegate = info.isDelegate() && index++ == children.size() - 1;
            AssemblerInfo unionInfo = new AssemblerInfo(unionDeclaredType, info.getParent(), delegate, info.getFieldName(), info.getFieldIndex(), true);
            node.accept(this, unionInfo);
        }
        return info.getParent();
    }

    @Override
    public AbstractValueAssembler visit(PrimitiveSchemaNode primitiveNode, AssemblerInfo info) {
        AbstractPrimitiveValueAssembler assembler;
        IValueGetter valueGetter = this.valueGetterFactory.createValueGetter(this.getTypeTag(info, primitiveNode));
        if (!this.delimiters.isEmpty()) {
            IColumnValuesReader reader = this.readerFactory.createValueReader(primitiveNode.getTypeTag(), primitiveNode.getColumnIndex(), this.level, this.getDelimiters());
            assembler = new RepeatedPrimitiveValueAssembler(this.level, info, reader, valueGetter);
            this.setDelegate(reader, (RepeatedPrimitiveValueAssembler)assembler);
        } else {
            boolean primaryKey = primitiveNode.isPrimaryKey();
            IColumnValuesReader reader = primaryKey ? this.primaryKeyReaders.get(primitiveNode.getColumnIndex()) : this.readerFactory.createValueReader(primitiveNode.getTypeTag(), primitiveNode.getColumnIndex(), this.level, false);
            assembler = new PrimitiveValueAssembler(this.level, info, reader, valueGetter, primaryKey);
        }
        this.valueAssemblers.add(assembler);
        return assembler;
    }

    private ATypeTag getTypeTag(AssemblerInfo info, PrimitiveSchemaNode primitiveNode) {
        IAType declaredType = info.getDeclaredType();
        if (declaredType.getTypeTag() == ATypeTag.ANY) {
            return primitiveNode.getTypeTag();
        }
        return declaredType.getTypeTag();
    }

    private int[] getDelimiters() {
        int numOfDelimiters = this.delimiters.size();
        int[] reversed = new int[numOfDelimiters];
        for (int i = 0; i < numOfDelimiters; ++i) {
            reversed[i] = this.delimiters.getInt(numOfDelimiters - i - 1);
        }
        return reversed;
    }

    private IAType getChildType(AbstractSchemaNode childNode, IAType childType) {
        if (childType.getTypeTag() != ATypeTag.ANY) {
            return childType;
        }
        ATypeTag childTypeTag = childNode.getTypeTag();
        if (childTypeTag == ATypeTag.UNION) {
            return BuiltinType.ANY;
        }
        if (childTypeTag.isDerivedType()) {
            return DefaultOpenFieldType.getDefaultOpenFieldType((ATypeTag)childTypeTag);
        }
        return BuiltinType.getBuiltinType((ATypeTag)childTypeTag);
    }

    private void setDelegate(IColumnValuesReader reader, RepeatedPrimitiveValueAssembler assembler) {
        int delegateIndex;
        int n = delegateIndex = this.delegateAssembler == null ? Integer.MAX_VALUE : this.delegateAssembler.getReader().getColumnIndex();
        if (delegateIndex > reader.getColumnIndex()) {
            this.delegateAssembler = assembler;
        }
    }
}

