/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.operators;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.context.PrimaryIndexOperationTracker;
import org.apache.asterix.common.dataflow.LSMIndexUtil;
import org.apache.asterix.common.dataflow.NoOpFrameOperationCallbackFactory;
import org.apache.asterix.common.messaging.AtomicJobPreparedMessage;
import org.apache.asterix.common.transactions.ILogManager;
import org.apache.asterix.common.transactions.PrimaryIndexLogMarkerCallback;
import org.apache.asterix.transaction.management.opcallbacks.LockThenSearchOperationCallback;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.comm.IFrameTupleAppender;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.comm.VSizeFrame;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.IDestroyable;
import org.apache.hyracks.api.dataflow.IOperatorNodePushable;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ITuplePartitionerFactory;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.api.util.CleanupUtils;
import org.apache.hyracks.api.util.JavaSerializationUtils;
import org.apache.hyracks.control.nc.NodeControllerService;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import org.apache.hyracks.dataflow.common.comm.util.FrameUtils;
import org.apache.hyracks.dataflow.common.data.accessors.FrameTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.PermutingFrameTupleReference;
import org.apache.hyracks.dataflow.common.utils.TaskUtil;
import org.apache.hyracks.storage.am.btree.impls.RangePredicate;
import org.apache.hyracks.storage.am.btree.util.BTreeUtils;
import org.apache.hyracks.storage.am.common.api.IIndexDataflowHelper;
import org.apache.hyracks.storage.am.common.api.IModificationOperationCallbackFactory;
import org.apache.hyracks.storage.am.common.api.ISearchOperationCallbackFactory;
import org.apache.hyracks.storage.am.common.api.ITreeIndex;
import org.apache.hyracks.storage.am.common.dataflow.IIndexDataflowHelperFactory;
import org.apache.hyracks.storage.am.common.impls.IndexAccessParameters;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallback;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.am.common.util.ResourceReleaseUtils;
import org.apache.hyracks.storage.am.lsm.common.api.IFrameOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.api.IFrameTupleProcessor;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentId;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.dataflow.LSMIndexInsertUpdateDeleteOperatorNodePushable;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndex;
import org.apache.hyracks.storage.am.lsm.common.impls.FlushOperation;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMTreeIndexAccessor;
import org.apache.hyracks.storage.common.IIndex;
import org.apache.hyracks.storage.common.IIndexAccessParameters;
import org.apache.hyracks.storage.common.IIndexAccessor;
import org.apache.hyracks.storage.common.IIndexCursor;
import org.apache.hyracks.storage.common.IModificationOperationCallback;
import org.apache.hyracks.storage.common.ISearchOperationCallback;
import org.apache.hyracks.storage.common.ISearchPredicate;
import org.apache.hyracks.storage.common.MultiComparator;

public class LSMPrimaryInsertOperatorNodePushable
extends LSMIndexInsertUpdateDeleteOperatorNodePushable {
    private final boolean[] keyIndexHelpersOpen;
    private final IIndexDataflowHelper[] keyIndexHelpers;
    private MultiComparator keySearchCmp;
    private RangePredicate searchPred;
    private final IIndexCursor[] cursors;
    private final ISearchOperationCallback[] searchCallbacks;
    private final ISearchOperationCallbackFactory searchCallbackFactory;
    private final IFrameTupleProcessor[] processors;
    private final LSMTreeIndexAccessor[] lsmAccessorForKeyIndexes;
    private final LSMTreeIndexAccessor[] lsmAccessorForUniqunessChecks;
    private final IFrameOperationCallback[] frameOpCallbacks;
    private boolean flushedPartialTuples;
    private final PermutingFrameTupleReference keyTuple;
    private final Int2ObjectMap<IntSet> partition2TuplesMap = new Int2ObjectOpenHashMap();
    private final IntSet processedTuples = new IntOpenHashSet();
    private final IntSet flushedTuples = new IntOpenHashSet();
    private final SourceLocation sourceLoc;

    public LSMPrimaryInsertOperatorNodePushable(IHyracksTaskContext ctx, int partition, IIndexDataflowHelperFactory indexHelperFactory, IIndexDataflowHelperFactory keyIndexHelperFactory, int[] fieldPermutation, RecordDescriptor inputRecDesc, IModificationOperationCallbackFactory modCallbackFactory, ISearchOperationCallbackFactory searchCallbackFactory, int numOfPrimaryKeys, int[] filterFields, SourceLocation sourceLoc, ITuplePartitionerFactory tuplePartitionerFactory, int[][] partitionsMap) throws HyracksDataException {
        super(ctx, partition, indexHelperFactory, fieldPermutation, inputRecDesc, IndexOperation.UPSERT, modCallbackFactory, null, tuplePartitionerFactory, partitionsMap);
        int i;
        this.sourceLoc = sourceLoc;
        this.frameOpCallbacks = new IFrameOperationCallback[this.partitions.length];
        this.searchCallbacks = new ISearchOperationCallback[this.partitions.length];
        this.cursors = new IIndexCursor[this.partitions.length];
        this.lsmAccessorForUniqunessChecks = new LSMTreeIndexAccessor[this.partitions.length];
        this.lsmAccessorForKeyIndexes = new LSMTreeIndexAccessor[this.partitions.length];
        this.keyIndexHelpers = new IIndexDataflowHelper[this.partitions.length];
        this.keyIndexHelpersOpen = new boolean[this.partitions.length];
        this.processors = new IFrameTupleProcessor[this.partitions.length];
        if (keyIndexHelperFactory != null) {
            for (int i2 = 0; i2 < this.partitions.length; ++i2) {
                this.keyIndexHelpers[i2] = keyIndexHelperFactory.create(ctx.getJobletContext().getServiceContext(), this.partitions[i2]);
            }
        }
        this.searchCallbackFactory = searchCallbackFactory;
        int numFilterFieds = filterFields != null ? filterFields.length : 0;
        int[] searchKeyPermutations = new int[numOfPrimaryKeys + numFilterFieds];
        for (i = 0; i < numOfPrimaryKeys; ++i) {
            searchKeyPermutations[i] = fieldPermutation[i];
        }
        if (filterFields != null) {
            for (i = numOfPrimaryKeys; i < searchKeyPermutations.length; ++i) {
                searchKeyPermutations[i] = filterFields[i - numOfPrimaryKeys];
            }
        }
        this.keyTuple = new PermutingFrameTupleReference(searchKeyPermutations);
    }

    protected void beforeModification(ITupleReference tuple) {
    }

    protected void createTupleProcessors(final SourceLocation sourceLoc) {
        for (int i = 0; i < this.partitions.length; ++i) {
            final LSMTreeIndexAccessor lsmAccessorForUniqunessCheck = this.lsmAccessorForUniqunessChecks[i];
            final IIndexCursor cursor = this.cursors[i];
            final IIndexAccessor indexAccessor = this.indexAccessors[i];
            final LSMTreeIndexAccessor lsmAccessorForKeyIndex = this.lsmAccessorForKeyIndexes[i];
            final ISearchOperationCallback searchCallback = this.searchCallbacks[i];
            this.processors[i] = new IFrameTupleProcessor(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void process(FrameTupleAccessor accessor, ITupleReference tuple, int index) throws HyracksDataException {
                    if (LSMPrimaryInsertOperatorNodePushable.this.processedTuples.contains(index)) {
                        return;
                    }
                    LSMPrimaryInsertOperatorNodePushable.this.keyTuple.reset((IFrameTupleAccessor)accessor, index);
                    LSMPrimaryInsertOperatorNodePushable.this.searchPred.reset((ITupleReference)LSMPrimaryInsertOperatorNodePushable.this.keyTuple, (ITupleReference)LSMPrimaryInsertOperatorNodePushable.this.keyTuple, true, true, LSMPrimaryInsertOperatorNodePushable.this.keySearchCmp, LSMPrimaryInsertOperatorNodePushable.this.keySearchCmp);
                    boolean duplicate = false;
                    lsmAccessorForUniqunessCheck.search(cursor, (ISearchPredicate)LSMPrimaryInsertOperatorNodePushable.this.searchPred);
                    try {
                        if (cursor.hasNext()) {
                            if (searchCallback instanceof LockThenSearchOperationCallback) {
                                ((LockThenSearchOperationCallback)searchCallback).release();
                            }
                            duplicate = true;
                        }
                    }
                    finally {
                        cursor.close();
                    }
                    if (!duplicate) {
                        LSMPrimaryInsertOperatorNodePushable.this.beforeModification(tuple);
                        ((ILSMIndexAccessor)indexAccessor).forceUpsert(tuple);
                        if (lsmAccessorForKeyIndex != null) {
                            lsmAccessorForKeyIndex.forceUpsert((ITupleReference)LSMPrimaryInsertOperatorNodePushable.this.keyTuple);
                        }
                    } else {
                        LSMPrimaryInsertOperatorNodePushable.this.flushPartialFrame();
                        throw HyracksDataException.create((ErrorCode)ErrorCode.ERROR_PROCESSING_TUPLE, (Throwable)HyracksDataException.create((ErrorCode)ErrorCode.DUPLICATE_KEY, (Serializable[])new Serializable[0]), (SourceLocation)sourceLoc, (Serializable[])new Serializable[]{Integer.valueOf(index)});
                    }
                    LSMPrimaryInsertOperatorNodePushable.this.processedTuples.add(index);
                }

                public void start() throws HyracksDataException {
                    ((LSMTreeIndexAccessor)indexAccessor).getCtx().setOperation(IndexOperation.UPSERT);
                }

                public void finish() throws HyracksDataException {
                    ((LSMTreeIndexAccessor)indexAccessor).getCtx().setOperation(IndexOperation.UPSERT);
                }

                public void fail(Throwable th) {
                }
            };
        }
    }

    public void open() throws HyracksDataException {
        this.flushedPartialTuples = false;
        this.accessor = new FrameTupleAccessor(this.inputRecDesc);
        this.writeBuffer = new VSizeFrame((IHyracksFrameMgrContext)this.ctx);
        try {
            INcApplicationContext appCtx = (INcApplicationContext)this.ctx.getJobletContext().getServiceContext().getApplicationContext();
            this.writer.open();
            this.writerOpen = true;
            for (int i = 0; i < this.partitions.length; ++i) {
                IIndex indexForUniquessCheck;
                IIndexDataflowHelper keyIndexHelper;
                IIndexDataflowHelper indexHelper = this.indexHelpers[i];
                this.indexHelpersOpen[i] = true;
                indexHelper.open();
                this.indexes[i] = indexHelper.getIndexInstance();
                IIndex index = this.indexes[i];
                if (((ILSMIndex)this.indexes[i]).isAtomic()) {
                    ((PrimaryIndexOperationTracker)((ILSMIndex)this.indexes[i]).getOperationTracker()).clear();
                }
                if ((keyIndexHelper = this.keyIndexHelpers[i]) != null) {
                    this.keyIndexHelpersOpen[i] = true;
                    keyIndexHelper.open();
                    indexForUniquessCheck = keyIndexHelper.getIndexInstance();
                } else {
                    indexForUniquessCheck = index;
                }
                if (this.ctx.getSharedObject() != null && i == 0) {
                    PrimaryIndexLogMarkerCallback callback = new PrimaryIndexLogMarkerCallback((ILSMIndex)((AbstractLSMIndex)this.indexes[0]));
                    TaskUtil.put((String)"MARKER_CALLBACK", (Object)callback, (IHyracksTaskContext)this.ctx);
                }
                this.modCallbacks[i] = this.modOpCallbackFactory.createModificationOperationCallback(indexHelper.getResource(), this.ctx, (IOperatorNodePushable)this);
                this.searchCallbacks[i] = this.searchCallbackFactory.createSearchOperationCallback(indexHelper.getResource().getId(), this.ctx, (IOperatorNodePushable)this);
                IndexAccessParameters iap = new IndexAccessParameters(this.modCallbacks[i], (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
                this.indexAccessors[i] = index.createAccessor((IIndexAccessParameters)iap);
                if (keyIndexHelper != null) {
                    this.lsmAccessorForKeyIndexes[i] = (LSMTreeIndexAccessor)indexForUniquessCheck.createAccessor((IIndexAccessParameters)iap);
                }
                this.frameOpCallbacks[i] = NoOpFrameOperationCallbackFactory.INSTANCE.createFrameOperationCallback(this.ctx, (ILSMIndexAccessor)this.indexAccessors[i]);
                this.frameOpCallbacks[i].open();
                IndexAccessParameters iapForUniquenessCheck = new IndexAccessParameters((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, this.searchCallbacks[i]);
                this.lsmAccessorForUniqunessChecks[i] = (LSMTreeIndexAccessor)indexForUniquessCheck.createAccessor((IIndexAccessParameters)iapForUniquenessCheck);
                this.setAtomicOpContextIfAtomic(indexForUniquessCheck, (IIndexAccessor)this.lsmAccessorForUniqunessChecks[i]);
                this.cursors[i] = this.lsmAccessorForUniqunessChecks[i].createSearchCursor(false);
                LSMIndexUtil.checkAndSetFirstLSN((AbstractLSMIndex)((AbstractLSMIndex)index), (ILogManager)appCtx.getTransactionSubsystem().getLogManager());
            }
            this.createTupleProcessors(this.sourceLoc);
            this.keySearchCmp = BTreeUtils.getSearchMultiComparator((IBinaryComparatorFactory[])((ITreeIndex)this.indexes[0]).getComparatorFactories(), (ITupleReference)this.frameTuple);
            this.searchPred = new RangePredicate((ITupleReference)this.frameTuple, (ITupleReference)this.frameTuple, true, true, this.keySearchCmp, this.keySearchCmp, null, null);
            this.appender = new FrameTupleAppender((IFrame)new VSizeFrame((IHyracksFrameMgrContext)this.ctx), true);
            this.frameTuple = new FrameTupleReference();
        }
        catch (Throwable e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        int pIdx;
        this.accessor.reset(buffer);
        this.partition2TuplesMap.clear();
        int itemCount = this.accessor.getTupleCount();
        for (int i = 0; i < itemCount; ++i) {
            int storagePartition = this.tuplePartitioner.partition((IFrameTupleAccessor)this.accessor, i);
            pIdx = this.storagePartitionId2Index.get(storagePartition);
            IntSet tupleIndexes = (IntSet)this.partition2TuplesMap.computeIfAbsent(pIdx, k -> new IntOpenHashSet());
            tupleIndexes.add(i);
        }
        for (Int2ObjectMap.Entry p2tuplesMapEntry : this.partition2TuplesMap.int2ObjectEntrySet()) {
            pIdx = p2tuplesMapEntry.getIntKey();
            LSMTreeIndexAccessor lsmAccessor = (LSMTreeIndexAccessor)this.indexAccessors[pIdx];
            IFrameOperationCallback frameOpCallback = this.frameOpCallbacks[pIdx];
            IFrameTupleProcessor processor = this.processors[pIdx];
            lsmAccessor.batchOperate(this.accessor, (FrameTupleReference)this.tuple, processor, frameOpCallback, (Set)p2tuplesMapEntry.getValue());
        }
        this.writeBuffer.ensureFrameSize(buffer.capacity());
        if (this.flushedPartialTuples) {
            this.flushPartialFrame();
        } else {
            FrameUtils.copyAndFlip((ByteBuffer)buffer, (ByteBuffer)this.writeBuffer.getBuffer());
            FrameUtils.flushFrame((ByteBuffer)this.writeBuffer.getBuffer(), (IFrameWriter)this.writer);
        }
        this.flushedPartialTuples = false;
        this.processedTuples.clear();
        this.flushedTuples.clear();
    }

    public void flushPartialFrame() throws HyracksDataException {
        IntArrayList tuplesToFlush = new IntArrayList();
        this.processedTuples.iterator().forEachRemaining(arg_0 -> this.lambda$flushPartialFrame$1((IntList)tuplesToFlush, arg_0));
        for (int i = 0; i < tuplesToFlush.size(); ++i) {
            FrameUtils.appendToWriter((IFrameWriter)this.writer, (IFrameTupleAppender)this.appender, (IFrameTupleAccessor)this.accessor, (int)tuplesToFlush.getInt(i));
        }
        this.appender.write(this.writer, true);
        this.flushedPartialTuples = true;
    }

    public void close() throws HyracksDataException {
        Throwable failure = CleanupUtils.destroy(null, (IDestroyable[])this.cursors);
        failure = CleanupUtils.close((IFrameWriter)this.writer, (Throwable)failure);
        failure = this.closeIndexHelpers(failure);
        if ((failure = this.closeKeyIndexHelpers(failure)) == null && !this.failed) {
            this.commitAtomicInsert();
        } else {
            this.abortAtomicInsert();
        }
        if (failure != null) {
            throw HyracksDataException.create((Throwable)failure);
        }
    }

    public void fail() throws HyracksDataException {
        this.failed = true;
        this.writer.fail();
    }

    public void flush() throws HyracksDataException {
    }

    private void commitAtomicInsert() throws HyracksDataException {
        HashMap<String, ILSMComponentId> componentIdMap = new HashMap<String, ILSMComponentId>();
        boolean atomic = false;
        for (IIndex index : this.indexes) {
            if (index == null || !((ILSMIndex)index).isAtomic()) continue;
            PrimaryIndexOperationTracker opTracker = (PrimaryIndexOperationTracker)((ILSMIndex)index).getOperationTracker();
            opTracker.finishAllFlush();
            for (Map.Entry entry : opTracker.getLastFlushOperation().entrySet()) {
                componentIdMap.put((String)entry.getKey(), ((FlushOperation)entry.getValue()).getFlushingComponent().getId());
            }
            atomic = true;
        }
        if (atomic) {
            AtomicJobPreparedMessage message = new AtomicJobPreparedMessage(this.ctx.getJobletContext().getJobId(), this.ctx.getJobletContext().getServiceContext().getNodeId(), componentIdMap);
            try {
                ((NodeControllerService)this.ctx.getJobletContext().getServiceContext().getControllerService()).sendRealTimeApplicationMessageToCC(this.ctx.getJobletContext().getJobId().getCcId(), JavaSerializationUtils.serialize((Serializable)message), null);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void abortAtomicInsert() throws HyracksDataException {
        for (IIndex index : this.indexes) {
            if (index == null || !((ILSMIndex)index).isAtomic()) continue;
            PrimaryIndexOperationTracker opTracker = (PrimaryIndexOperationTracker)((ILSMIndex)index).getOperationTracker();
            opTracker.abort();
        }
    }

    private Throwable closeKeyIndexHelpers(Throwable failure) {
        for (int i = 0; i < this.keyIndexHelpers.length; ++i) {
            if (!this.keyIndexHelpersOpen[i]) continue;
            failure = ResourceReleaseUtils.close((IIndexDataflowHelper)this.keyIndexHelpers[i], (Throwable)failure);
        }
        return failure;
    }

    private /* synthetic */ void lambda$flushPartialFrame$1(IntList tuplesToFlush, int tIdx) {
        if (!this.flushedTuples.contains(tIdx)) {
            tuplesToFlush.add(tIdx);
            this.flushedTuples.add(tIdx);
        }
    }
}

