/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.utils;

import org.apache.asterix.common.cluster.PartitioningProperties;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataverse;
import org.apache.asterix.runtime.utils.RuntimeUtils;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraint;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraintHelper;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.dataflow.std.file.FileRemoveOperatorDescriptor;

public class DataverseUtil {
    private DataverseUtil() {
    }

    public static JobSpecification dropDataverseJobSpec(Dataverse dataverse, MetadataProvider md) {
        PartitioningProperties pp = md.splitAndConstraints(dataverse.getDatabaseName(), dataverse.getDataverseName());
        return DataverseUtil.dropJobSpec(md, pp);
    }

    public static JobSpecification dropDatabaseJobSpec(String database, MetadataProvider md) {
        PartitioningProperties pp = md.splitAndConstraints(database);
        return DataverseUtil.dropJobSpec(md, pp);
    }

    private static JobSpecification dropJobSpec(MetadataProvider metadata, PartitioningProperties pp) {
        JobSpecification jobSpec = RuntimeUtils.createJobSpecification((ICcApplicationContext)metadata.getApplicationContext());
        FileRemoveOperatorDescriptor frod = new FileRemoveOperatorDescriptor((IOperatorDescriptorRegistry)jobSpec, pp.getSplitsProvider(), false, pp.getComputeStorageMap());
        AlgebricksPartitionConstraintHelper.setPartitionConstraintInJobSpec((JobSpecification)jobSpec, (IOperatorDescriptor)frod, (AlgebricksPartitionConstraint)pp.getConstraints());
        jobSpec.addRoot((IOperatorDescriptor)frod);
        return jobSpec;
    }
}

