/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.metadata;

import java.io.Serializable;
import java.util.Objects;
import org.apache.asterix.common.metadata.DataverseName;

public final class Namespace
implements Serializable,
Comparable<Namespace> {
    private static final long serialVersionUID = 1L;
    private final String databaseName;
    private final DataverseName dataverseName;

    public Namespace(String databaseName, DataverseName dataverseName) {
        this.databaseName = Objects.requireNonNull(databaseName);
        this.dataverseName = Objects.requireNonNull(dataverseName);
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public DataverseName getDataverseName() {
        return this.dataverseName;
    }

    public String toString() {
        return this.databaseName + "." + this.dataverseName;
    }

    public int hashCode() {
        return Objects.hash(this.databaseName, this.dataverseName);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Namespace)) {
            return false;
        }
        Namespace that = (Namespace)obj;
        return Objects.equals(this.databaseName, that.databaseName) && Objects.equals(this.dataverseName, that.dataverseName);
    }

    @Override
    public int compareTo(Namespace that) {
        int dbComp = this.databaseName.compareTo(that.getDatabaseName());
        if (dbComp == 0) {
            return this.dataverseName.compareTo(that.getDataverseName());
        }
        return dbComp;
    }
}

