/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.dataflow;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.context.PrimaryIndexOperationTracker;
import org.apache.asterix.common.dataflow.LSMIndexUtil;
import org.apache.asterix.common.messaging.AtomicJobPreparedMessage;
import org.apache.asterix.common.transactions.PrimaryIndexLogMarkerCallback;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.comm.IFrameTupleAppender;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.comm.VSizeFrame;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.IOperatorNodePushable;
import org.apache.hyracks.api.dataflow.value.ITuplePartitionerFactory;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.IError;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.api.util.ExceptionUtils;
import org.apache.hyracks.api.util.JavaSerializationUtils;
import org.apache.hyracks.control.nc.NodeControllerService;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import org.apache.hyracks.dataflow.common.comm.util.FrameUtils;
import org.apache.hyracks.dataflow.common.data.accessors.FrameTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.dataflow.common.utils.TaskUtil;
import org.apache.hyracks.storage.am.common.api.IIndexDataflowHelper;
import org.apache.hyracks.storage.am.common.api.IModificationOperationCallbackFactory;
import org.apache.hyracks.storage.am.common.api.ITupleFilterFactory;
import org.apache.hyracks.storage.am.common.dataflow.IIndexDataflowHelperFactory;
import org.apache.hyracks.storage.am.common.impls.IndexAccessParameters;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallback;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentId;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.dataflow.LSMIndexInsertUpdateDeleteOperatorNodePushable;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndex;
import org.apache.hyracks.storage.am.lsm.common.impls.FlushOperation;
import org.apache.hyracks.storage.common.IIndex;
import org.apache.hyracks.storage.common.IIndexAccessParameters;
import org.apache.hyracks.storage.common.ISearchOperationCallback;
import org.apache.hyracks.storage.common.LocalResource;

public class LSMInsertDeleteOperatorNodePushable
extends LSMIndexInsertUpdateDeleteOperatorNodePushable {
    protected final boolean isPrimary;
    protected final SourceLocation sourceLoc;
    protected int i = 0;
    protected boolean flushedPartialTuples;
    protected int currentTupleIdx;
    protected int lastFlushedTupleIdx;

    public LSMInsertDeleteOperatorNodePushable(IHyracksTaskContext ctx, int partition, int[] fieldPermutation, RecordDescriptor inputRecDesc, IndexOperation op, boolean isPrimary, IIndexDataflowHelperFactory indexHelperFactory, IModificationOperationCallbackFactory modCallbackFactory, ITupleFilterFactory tupleFilterFactory, SourceLocation sourceLoc, ITuplePartitionerFactory tuplePartitionerFactory, int[][] partitionsMap) throws HyracksDataException {
        super(ctx, partition, indexHelperFactory, fieldPermutation, inputRecDesc, op, modCallbackFactory, tupleFilterFactory, tuplePartitionerFactory, partitionsMap);
        this.isPrimary = isPrimary;
        this.sourceLoc = sourceLoc;
    }

    public void open() throws HyracksDataException {
        this.i = 0;
        this.currentTupleIdx = 0;
        this.lastFlushedTupleIdx = 0;
        this.flushedPartialTuples = false;
        this.accessor = new FrameTupleAccessor(this.inputRecDesc);
        this.writeBuffer = new VSizeFrame((IHyracksFrameMgrContext)this.ctx);
        this.appender = new FrameTupleAppender(this.writeBuffer);
        try {
            INcApplicationContext runtimeCtx = (INcApplicationContext)this.ctx.getJobletContext().getServiceContext().getApplicationContext();
            for (int i = 0; i < this.indexHelpers.length; ++i) {
                IIndexDataflowHelper indexHelper = this.indexHelpers[i];
                this.indexHelpersOpen[i] = true;
                indexHelper.open();
                this.indexes[i] = indexHelper.getIndexInstance();
                if (((ILSMIndex)this.indexes[i]).isAtomic() && this.isPrimary()) {
                    ((PrimaryIndexOperationTracker)((ILSMIndex)this.indexes[i]).getOperationTracker()).clear();
                }
                LocalResource resource = indexHelper.getResource();
                this.modCallbacks[i] = this.modOpCallbackFactory.createModificationOperationCallback(resource, this.ctx, (IOperatorNodePushable)this);
                IndexAccessParameters iap = new IndexAccessParameters(this.modCallbacks[i], (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
                this.indexAccessors[i] = this.indexes[i].createAccessor((IIndexAccessParameters)iap);
                LSMIndexUtil.checkAndSetFirstLSN((AbstractLSMIndex)this.indexes[i], runtimeCtx.getTransactionSubsystem().getLogManager());
            }
            if (this.isPrimary && this.ctx.getSharedObject() != null) {
                PrimaryIndexLogMarkerCallback callback = new PrimaryIndexLogMarkerCallback((ILSMIndex)this.indexes[0]);
                TaskUtil.put((String)"MARKER_CALLBACK", (Object)callback, (IHyracksTaskContext)this.ctx);
            }
            this.writer.open();
            this.writerOpen = true;
            if (this.tupleFilterFactory != null) {
                this.tupleFilter = this.tupleFilterFactory.createTupleFilter(this.ctx);
                this.frameTuple = new FrameTupleReference();
            }
        }
        catch (Throwable th) {
            throw HyracksDataException.create((Throwable)th);
        }
    }

    public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        this.accessor.reset(buffer);
        int tupleCount = this.accessor.getTupleCount();
        try {
            while (this.i < tupleCount) {
                block17: {
                    block16: {
                        if (this.tupleFilter == null) break block16;
                        this.frameTuple.reset((IFrameTupleAccessor)this.accessor, this.i);
                        if (!this.tupleFilter.accept((IFrameTupleReference)this.frameTuple)) break block17;
                    }
                    this.tuple.reset((IFrameTupleAccessor)this.accessor, this.i);
                    int storagePartition = this.tuplePartitioner.partition((IFrameTupleAccessor)this.accessor, this.i);
                    int storageIdx = this.storagePartitionId2Index.get(storagePartition);
                    ILSMIndexAccessor lsmAccessor = (ILSMIndexAccessor)this.indexAccessors[storageIdx];
                    switch (this.op) {
                        case INSERT: {
                            if (this.i == 0 && this.isPrimary) {
                                lsmAccessor.insert((ITupleReference)this.tuple);
                                break;
                            }
                            lsmAccessor.forceInsert((ITupleReference)this.tuple);
                            break;
                        }
                        case DELETE: {
                            if (this.i == 0 && this.isPrimary) {
                                lsmAccessor.delete((ITupleReference)this.tuple);
                                break;
                            }
                            lsmAccessor.forceDelete((ITupleReference)this.tuple);
                            break;
                        }
                        default: {
                            throw HyracksDataException.create((ErrorCode)ErrorCode.INVALID_OPERATOR_OPERATION, (SourceLocation)this.sourceLoc, (Serializable[])new Serializable[]{this.op.toString(), LSMInsertDeleteOperatorNodePushable.class.getSimpleName()});
                        }
                    }
                }
                ++this.i;
                ++this.currentTupleIdx;
            }
        }
        catch (HyracksDataException e) {
            if (e.matches((IError)ErrorCode.INVALID_OPERATOR_OPERATION)) {
                throw e;
            }
            throw HyracksDataException.create((ErrorCode)ErrorCode.ERROR_PROCESSING_TUPLE, (Throwable)e, (SourceLocation)this.sourceLoc, (Serializable[])new Serializable[]{Integer.valueOf(this.i)});
        }
        catch (Exception e) {
            throw HyracksDataException.create((ErrorCode)ErrorCode.ERROR_PROCESSING_TUPLE, (Throwable)e, (SourceLocation)this.sourceLoc, (Serializable[])new Serializable[]{Integer.valueOf(this.i)});
        }
        this.writeBuffer.ensureFrameSize(buffer.capacity());
        if (this.flushedPartialTuples) {
            this.flushPartialFrame();
        } else {
            FrameUtils.copyAndFlip((ByteBuffer)buffer, (ByteBuffer)this.writeBuffer.getBuffer());
            FrameUtils.flushFrame((ByteBuffer)this.writeBuffer.getBuffer(), (IFrameWriter)this.writer);
        }
        this.i = 0;
        this.currentTupleIdx = 0;
        this.lastFlushedTupleIdx = 0;
        this.flushedPartialTuples = false;
    }

    public void flushPartialFrame() throws HyracksDataException {
        if (this.lastFlushedTupleIdx == this.currentTupleIdx) {
            return;
        }
        for (int i = this.lastFlushedTupleIdx; i < this.currentTupleIdx; ++i) {
            FrameUtils.appendToWriter((IFrameWriter)this.writer, (IFrameTupleAppender)this.appender, (IFrameTupleAccessor)this.accessor, (int)i);
        }
        this.appender.write(this.writer, true);
        this.lastFlushedTupleIdx = this.currentTupleIdx;
        this.flushedPartialTuples = true;
    }

    public void close() throws HyracksDataException {
        Throwable failure = this.closeIndexHelpers(null);
        if (this.writerOpen) {
            try {
                this.writer.close();
            }
            catch (Throwable th) {
                failure = ExceptionUtils.suppress((Throwable)failure, (Throwable)th);
            }
        }
        if (failure == null && !this.failed) {
            this.commitAtomicInsertDelete();
        } else {
            this.abortAtomicInsertDelete();
        }
        if (failure != null) {
            throw HyracksDataException.create((Throwable)failure);
        }
    }

    public void fail() throws HyracksDataException {
        this.failed = true;
        if (this.writerOpen) {
            this.writer.fail();
        }
    }

    public boolean isPrimary() {
        return this.isPrimary;
    }

    private void commitAtomicInsertDelete() throws HyracksDataException {
        if (this.isPrimary) {
            HashMap<String, ILSMComponentId> componentIdMap = new HashMap<String, ILSMComponentId>();
            boolean atomic = false;
            for (IIndex index : this.indexes) {
                if (index == null || !((ILSMIndex)index).isAtomic()) continue;
                PrimaryIndexOperationTracker opTracker = (PrimaryIndexOperationTracker)((ILSMIndex)index).getOperationTracker();
                opTracker.finishAllFlush();
                for (Map.Entry<String, FlushOperation> entry : opTracker.getLastFlushOperation().entrySet()) {
                    componentIdMap.put(entry.getKey(), entry.getValue().getFlushingComponent().getId());
                }
                atomic = true;
            }
            if (atomic) {
                AtomicJobPreparedMessage message = new AtomicJobPreparedMessage(this.ctx.getJobletContext().getJobId(), this.ctx.getJobletContext().getServiceContext().getNodeId(), componentIdMap);
                try {
                    ((NodeControllerService)this.ctx.getJobletContext().getServiceContext().getControllerService()).sendRealTimeApplicationMessageToCC(this.ctx.getJobletContext().getJobId().getCcId(), JavaSerializationUtils.serialize((Serializable)((Object)message)), null);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private void abortAtomicInsertDelete() throws HyracksDataException {
        if (this.isPrimary) {
            for (IIndex index : this.indexes) {
                if (index == null || !((ILSMIndex)index).isAtomic()) continue;
                PrimaryIndexOperationTracker opTracker = (PrimaryIndexOperationTracker)((ILSMIndex)index).getOperationTracker();
                opTracker.abort();
            }
        }
    }
}

