/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.stream;

import java.io.IOException;
import java.util.Map;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.external.api.AsterixInputStream;
import org.apache.asterix.external.input.record.reader.hdfs.EmptyRecordReader;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;

public class HDFSInputStream
extends AsterixInputStream {
    private RecordReader<Object, Text> reader;
    private Text value = null;
    private Object key = null;
    private int currentSplitIndex = 0;
    private boolean[] read;
    private InputFormat<?, Text> inputFormat;
    private InputSplit[] inputSplits;
    private String[] readSchedule;
    private String nodeName;
    private JobConf conf;
    private int pos = 0;

    public HDFSInputStream(boolean[] read, InputSplit[] inputSplits, String[] readSchedule, String nodeName, JobConf conf, Map<String, String> configuration) throws IOException, AsterixException {
        this.read = read;
        this.inputSplits = inputSplits;
        this.readSchedule = readSchedule;
        this.nodeName = nodeName;
        this.conf = conf;
        this.inputFormat = conf.getInputFormat();
        this.reader = new EmptyRecordReader<Object, Text>();
        this.nextInputSplit();
        this.value = new Text();
    }

    @Override
    public int read() throws IOException {
        if (this.value.getLength() < this.pos) {
            if (!this.readMore()) {
                return -1;
            }
        } else if (this.value.getLength() == this.pos) {
            ++this.pos;
            return 10;
        }
        return this.value.getBytes()[this.pos++];
    }

    private int readRecord(byte[] buffer, int offset, int len) {
        int actualLength = this.value.getLength() + 1;
        if (actualLength - this.pos > len) {
            System.arraycopy(this.value.getBytes(), this.pos, buffer, offset, len);
            this.pos += len;
            return len;
        }
        int numBytes = this.value.getLength() - this.pos;
        System.arraycopy(this.value.getBytes(), this.pos, buffer, offset, numBytes);
        buffer[offset + numBytes] = 10;
        this.pos += numBytes;
        return ++numBytes;
    }

    @Override
    public int read(byte[] buffer, int offset, int len) throws IOException {
        if (this.value.getLength() > this.pos) {
            return this.readRecord(buffer, offset, len);
        }
        if (!this.readMore()) {
            return -1;
        }
        return this.readRecord(buffer, offset, len);
    }

    private boolean readMore() throws IOException {
        try {
            this.pos = 0;
            return this.hasNext();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public boolean stop() throws Exception {
        return false;
    }

    @Override
    public boolean handleException(Throwable th) {
        return false;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    private boolean hasNext() throws Exception {
        if (this.reader.next(this.key, (Object)this.value)) {
            return true;
        }
        while (this.nextInputSplit()) {
            if (!this.reader.next(this.key, (Object)this.value)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private boolean nextInputSplit() throws IOException {
        while (this.currentSplitIndex < this.inputSplits.length) {
            if (this.readSchedule[this.currentSplitIndex].equals(this.nodeName)) {
                boolean[] blArray = this.read;
                // MONITORENTER : this.read
                if (!this.read[this.currentSplitIndex]) {
                    this.read[this.currentSplitIndex] = true;
                    // MONITOREXIT : blArray
                    this.reader.close();
                    this.reader = this.getRecordReader(this.currentSplitIndex);
                    return true;
                }
                // MONITOREXIT : blArray
            }
            ++this.currentSplitIndex;
        }
        return false;
    }

    private RecordReader<Object, Text> getRecordReader(int splitIndex) throws IOException {
        this.reader = this.inputFormat.getRecordReader(this.inputSplits[splitIndex], this.conf, Reporter.NULL);
        if (this.key == null) {
            this.key = this.reader.createKey();
            this.value = (Text)this.reader.createValue();
        }
        return this.reader;
    }
}

