/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.common.config;

import java.lang.annotation.Annotation;
import org.apache.hyracks.api.config.IOption;
import org.apache.hyracks.control.common.config.ConfigManager;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.spi.ExplicitBooleanOptionHandler;
import org.kohsuke.args4j.spi.IntOptionHandler;
import org.kohsuke.args4j.spi.OptionHandler;
import org.kohsuke.args4j.spi.StringOptionHandler;

class Args4jOption
implements Option {
    private final IOption option;
    private final ConfigManager configManager;
    private final Class targetType;

    Args4jOption(IOption option, ConfigManager configManager, Class targetType) {
        this.option = option;
        this.targetType = targetType;
        this.configManager = configManager;
    }

    public String name() {
        return this.option.cmdline();
    }

    public String[] aliases() {
        return new String[0];
    }

    public String usage() {
        return this.configManager.getUsage(this.option);
    }

    public String metaVar() {
        return "";
    }

    public boolean required() {
        return false;
    }

    public boolean help() {
        return false;
    }

    public boolean hidden() {
        return this.option.hidden();
    }

    public Class<? extends OptionHandler> handler() {
        if (this.targetType.equals(Boolean.class)) {
            return ExplicitBooleanOptionHandler.class;
        }
        if (this.targetType.equals(Integer.class)) {
            return IntOptionHandler.class;
        }
        return StringOptionHandler.class;
    }

    public String[] depends() {
        return new String[0];
    }

    public String[] forbids() {
        return new String[0];
    }

    public Class<? extends Annotation> annotationType() {
        return Option.class;
    }
}

