/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import org.apache.asterix.dataflow.data.nontagged.serde.ADoubleSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AFloatSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt16SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt32SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt64SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt8SerializerDeserializer;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AMutableDouble;
import org.apache.asterix.om.base.AMutableFloat;
import org.apache.asterix.om.base.AMutableInt64;
import org.apache.asterix.om.exceptions.ExceptionUtil;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.runtime.evaluators.common.ArgumentUtils;
import org.apache.asterix.runtime.evaluators.functions.AbstractScalarEval;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

class NumericRoundEvaluator
extends AbstractScalarEval {
    private final IEvaluatorContext ctx;
    private ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    private AMutableInt64 aInt64 = new AMutableInt64(0L);
    private AMutableFloat aFloat = new AMutableFloat(0.0f);
    private AMutableDouble aDouble = new AMutableDouble(0.0);
    private final IScalarEvaluator valueEvaluator;
    private IScalarEvaluator roundingDigitEvaluator;
    private final IPointable valuePointable;
    private IPointable roundingDigitPointable;
    protected ISerializerDeserializer int64Serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT64);
    protected ISerializerDeserializer floatSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AFLOAT);
    protected ISerializerDeserializer doubleSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ADOUBLE);
    private static final byte[] INT_TYPES = new byte[]{ATypeTag.SERIALIZED_INT8_TYPE_TAG, ATypeTag.SERIALIZED_INT16_TYPE_TAG, ATypeTag.SERIALIZED_INT32_TYPE_TAG, ATypeTag.SERIALIZED_INT64_TYPE_TAG};

    NumericRoundEvaluator(IEvaluatorContext context, IScalarEvaluatorFactory[] argEvaluatorFactories, FunctionIdentifier functionIdentifier, SourceLocation sourceLocation) throws HyracksDataException {
        super(sourceLocation, functionIdentifier);
        this.ctx = context;
        this.valueEvaluator = argEvaluatorFactories[0].createScalarEvaluator(context);
        this.valuePointable = new VoidPointable();
        if (argEvaluatorFactories.length > 1) {
            this.roundingDigitEvaluator = argEvaluatorFactories[1].createScalarEvaluator(context);
            this.roundingDigitPointable = new VoidPointable();
        }
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        long roundingDigit;
        this.resultStorage.reset();
        this.valueEvaluator.evaluate(tuple, this.valuePointable);
        if (this.roundingDigitEvaluator != null) {
            this.roundingDigitEvaluator.evaluate(tuple, this.roundingDigitPointable);
        }
        if (PointableHelper.checkAndSetMissingOrNull(result, this.valuePointable, this.roundingDigitPointable)) {
            return;
        }
        byte[] valueBytes = this.valuePointable.getByteArray();
        int valueOffset = this.valuePointable.getStartOffset();
        ATypeTag valueTypeTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(valueBytes[valueOffset]);
        byte[] roundingDigitBytes = null;
        int roundingDigitOffset = 0;
        if (this.roundingDigitEvaluator != null) {
            roundingDigitBytes = this.roundingDigitPointable.getByteArray();
            roundingDigitOffset = this.roundingDigitPointable.getStartOffset();
        }
        if (!ATypeHierarchy.canPromote((ATypeTag)valueTypeTag, (ATypeTag)ATypeTag.DOUBLE)) {
            ExceptionUtil.warnTypeMismatch((IEvaluatorContext)this.ctx, (SourceLocation)this.srcLoc, (FunctionIdentifier)this.funID, (byte)valueBytes[valueOffset], (int)0, (byte[])ArgumentUtils.NUMERIC_TYPES);
            PointableHelper.setNull(result);
            return;
        }
        if (this.roundingDigitEvaluator != null && !PointableHelper.isValidLongValue(roundingDigitBytes, roundingDigitOffset, true)) {
            ExceptionUtil.warnTypeMismatch((IEvaluatorContext)this.ctx, (SourceLocation)this.srcLoc, (FunctionIdentifier)this.funID, (byte)roundingDigitBytes[roundingDigitOffset], (int)1, (byte[])INT_TYPES);
            PointableHelper.setNull(result);
            return;
        }
        long l = roundingDigit = this.roundingDigitEvaluator == null ? 0L : ATypeHierarchy.getLongValue((String)this.funID.getName(), (int)2, (byte[])roundingDigitBytes, (int)roundingDigitOffset);
        if (roundingDigit >= 0L) {
            double multiplier = Math.pow(10.0, roundingDigit);
            switch (valueTypeTag) {
                case TINYINT: {
                    this.aInt64.setValue((long)AInt8SerializerDeserializer.getByte((byte[])valueBytes, (int)(valueOffset + 1)));
                    this.int64Serde.serialize((Object)this.aInt64, this.resultStorage.getDataOutput());
                    break;
                }
                case SMALLINT: {
                    this.aInt64.setValue((long)AInt16SerializerDeserializer.getShort((byte[])valueBytes, (int)(valueOffset + 1)));
                    this.int64Serde.serialize((Object)this.aInt64, this.resultStorage.getDataOutput());
                    break;
                }
                case INTEGER: {
                    this.aInt64.setValue((long)AInt32SerializerDeserializer.getInt((byte[])valueBytes, (int)(valueOffset + 1)));
                    this.int64Serde.serialize((Object)this.aInt64, this.resultStorage.getDataOutput());
                    break;
                }
                case BIGINT: {
                    this.resultStorage.set((IValueReference)this.valuePointable);
                    break;
                }
                case FLOAT: {
                    float floatValue = AFloatSerializerDeserializer.getFloat((byte[])valueBytes, (int)(valueOffset + 1));
                    this.aFloat.setValue((float)Math.round(floatValue * (float)multiplier) / (float)multiplier);
                    this.floatSerde.serialize((Object)this.aFloat, this.resultStorage.getDataOutput());
                    break;
                }
                case DOUBLE: {
                    double doubleValue = ADoubleSerializerDeserializer.getDouble((byte[])valueBytes, (int)(valueOffset + 1));
                    this.aDouble.setValue((double)Math.round(doubleValue * multiplier) / multiplier);
                    this.doubleSerde.serialize((Object)this.aDouble, this.resultStorage.getDataOutput());
                    break;
                }
                default: {
                    ExceptionUtil.warnUnsupportedType((IEvaluatorContext)this.ctx, (SourceLocation)this.srcLoc, (String)this.funID.getName(), (ATypeTag)valueTypeTag);
                    PointableHelper.setNull(result);
                    return;
                }
            }
        } else {
            double multiplier = Math.pow(10.0, -roundingDigit);
            switch (valueTypeTag) {
                case TINYINT: {
                    byte byteValue = AInt8SerializerDeserializer.getByte((byte[])valueBytes, (int)(valueOffset + 1));
                    this.aInt64.setValue((long)((double)Math.round((double)byteValue / multiplier) * multiplier));
                    this.int64Serde.serialize((Object)this.aInt64, this.resultStorage.getDataOutput());
                    break;
                }
                case SMALLINT: {
                    short shortValue = AInt16SerializerDeserializer.getShort((byte[])valueBytes, (int)(valueOffset + 1));
                    this.aInt64.setValue((long)((double)Math.round((double)shortValue / multiplier) * multiplier));
                    this.int64Serde.serialize((Object)this.aInt64, this.resultStorage.getDataOutput());
                    break;
                }
                case INTEGER: {
                    int intValue = AInt32SerializerDeserializer.getInt((byte[])valueBytes, (int)(valueOffset + 1));
                    this.aInt64.setValue((long)((double)Math.round((double)intValue / multiplier) * multiplier));
                    this.int64Serde.serialize((Object)this.aInt64, this.resultStorage.getDataOutput());
                    break;
                }
                case BIGINT: {
                    long longValue = AInt64SerializerDeserializer.getLong((byte[])valueBytes, (int)(valueOffset + 1));
                    this.aInt64.setValue((long)((double)Math.round((double)longValue / multiplier) * multiplier));
                    this.int64Serde.serialize((Object)this.aInt64, this.resultStorage.getDataOutput());
                    break;
                }
                case FLOAT: {
                    float floatValue = AFloatSerializerDeserializer.getFloat((byte[])valueBytes, (int)(valueOffset + 1));
                    this.aFloat.setValue((float)Math.round(floatValue / (float)multiplier) * (float)multiplier);
                    this.floatSerde.serialize((Object)this.aFloat, this.resultStorage.getDataOutput());
                    break;
                }
                case DOUBLE: {
                    double doubleValue = ADoubleSerializerDeserializer.getDouble((byte[])valueBytes, (int)(valueOffset + 1));
                    this.aDouble.setValue((double)Math.round(doubleValue / multiplier) * multiplier);
                    this.doubleSerde.serialize((Object)this.aDouble, this.resultStorage.getDataOutput());
                    break;
                }
                default: {
                    ExceptionUtil.warnUnsupportedType((IEvaluatorContext)this.ctx, (SourceLocation)this.srcLoc, (String)this.funID.getName(), (ATypeTag)valueTypeTag);
                    PointableHelper.setNull(result);
                    return;
                }
            }
        }
        result.set((IValueReference)this.resultStorage);
    }
}

