/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.operators.physical;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.ListSet;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.IHyracksJobBuilder;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.base.PhysicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.AggregateFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IExpressionRuntimeProvider;
import org.apache.hyracks.algebricks.core.algebra.expressions.IPartialAggregationTypeComputer;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IOperatorSchema;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.OrderOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.AbstractGroupByPOperator;
import org.apache.hyracks.algebricks.core.algebra.properties.ILocalStructuralProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.IPhysicalPropertiesVector;
import org.apache.hyracks.algebricks.core.algebra.properties.LocalGroupingProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.LocalOrderProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.OrderColumn;
import org.apache.hyracks.algebricks.core.algebra.properties.PhysicalRequirements;
import org.apache.hyracks.algebricks.core.algebra.properties.StructuralPropertiesVector;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenContext;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenHelper;
import org.apache.hyracks.algebricks.core.jobgen.impl.OperatorSchemaImpl;
import org.apache.hyracks.algebricks.data.IBinaryComparatorFactoryProvider;
import org.apache.hyracks.algebricks.data.INormalizedKeyComputerFactoryProvider;
import org.apache.hyracks.algebricks.runtime.base.IAggregateEvaluatorFactory;
import org.apache.hyracks.algebricks.runtime.operators.aggreg.SimpleAlgebricksAccumulatingAggregatorFactory;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.INormalizedKeyComputerFactory;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.dataflow.std.group.IAggregatorDescriptorFactory;
import org.apache.hyracks.dataflow.std.group.sort.SortGroupByOperatorDescriptor;

public class SortGroupByPOperator
extends AbstractGroupByPOperator {
    private final OrderColumn[] orderColumns;

    public SortGroupByPOperator(List<LogicalVariable> columnList, OrderColumn[] orderColumns) {
        super(columnList);
        this.orderColumns = orderColumns;
    }

    @Override
    public PhysicalOperatorTag getOperatorTag() {
        return PhysicalOperatorTag.SORT_GROUP_BY;
    }

    @Override
    public boolean isMicroOperator() {
        return false;
    }

    @Override
    public void computeDeliveredProperties(ILogicalOperator op, IOptimizationContext context) {
        LinkedList<ILocalStructuralProperty> propsLocal = new LinkedList<ILocalStructuralProperty>();
        GroupByOperator gOp = (GroupByOperator)op;
        ListSet columnSet = new ListSet();
        ArrayList<OrderColumn> ocs = new ArrayList<OrderColumn>();
        if (!columnSet.isEmpty()) {
            propsLocal.add(new LocalGroupingProperty((Set<LogicalVariable>)columnSet));
        }
        for (OrderColumn oc : this.orderColumns) {
            ocs.add(oc);
        }
        propsLocal.add(new LocalOrderProperty(ocs));
        for (ILogicalPlan p : gOp.getNestedPlans()) {
            for (Mutable<ILogicalOperator> r : p.getRoots()) {
                ILogicalOperator rOp = (ILogicalOperator)r.getValue();
                propsLocal.addAll(rOp.getDeliveredPhysicalProperties().getLocalProperties());
            }
        }
        ILogicalOperator op2 = (ILogicalOperator)op.getInputs().get(0).getValue();
        IPhysicalPropertiesVector childProp = op2.getDeliveredPhysicalProperties();
        this.deliveredProperties = new StructuralPropertiesVector(childProp.getPartitioningProperty(), propsLocal);
    }

    @Override
    public PhysicalRequirements getRequiredPropertiesForChildren(ILogicalOperator op, IPhysicalPropertiesVector reqdByParent, IOptimizationContext context) {
        return this.emptyUnaryRequirements();
    }

    @Override
    public void contributeRuntimeOperator(IHyracksJobBuilder builder, JobGenContext context, ILogicalOperator op, IOperatorSchema opSchema, IOperatorSchema[] inputSchemas, IOperatorSchema outerPlanSchema) throws AlgebricksException {
        GroupByOperator gby = (GroupByOperator)op;
        this.checkGroupAll(gby);
        List<LogicalVariable> gbyCols = this.getGroupByColumns();
        int[] keys = JobGenHelper.variablesToFieldIndexes(gbyCols, inputSchemas[0]);
        int[] fdColumns = this.getFdColumns(gby, inputSchemas[0]);
        if (gby.getNestedPlans().size() != 1) {
            throw new AlgebricksException("Sort group-by currently works only for one nested plan with one root containingan aggregate and a nested-tuple-source.");
        }
        ILogicalPlan p0 = gby.getNestedPlans().get(0);
        if (p0.getRoots().size() != 1) {
            throw new AlgebricksException("Sort group-by currently works only for one nested plan with one root containingan aggregate and a nested-tuple-source.");
        }
        Mutable<ILogicalOperator> r0 = p0.getRoots().get(0);
        AggregateOperator aggOp = (AggregateOperator)r0.getValue();
        IPartialAggregationTypeComputer partialAggregationTypeComputer = context.getPartialAggregationTypeComputer();
        ArrayList<Object> intermediateTypes = new ArrayList<Object>();
        int n = aggOp.getExpressions().size();
        IAggregateEvaluatorFactory[] aff = new IAggregateEvaluatorFactory[n];
        int i = 0;
        IExpressionRuntimeProvider expressionRuntimeProvider = context.getExpressionRuntimeProvider();
        IVariableTypeEnvironment aggOpInputEnv = context.getTypeEnvironment((ILogicalOperator)aggOp.getInputs().get(0).getValue());
        IVariableTypeEnvironment outputEnv = context.getTypeEnvironment(op);
        for (Mutable<ILogicalExpression> exprRef : aggOp.getExpressions()) {
            Iterator<Object> aggFun = (AggregateFunctionCallExpression)exprRef.getValue();
            aff[i++] = expressionRuntimeProvider.createAggregateFunctionFactory((AggregateFunctionCallExpression)((Object)aggFun), aggOpInputEnv, inputSchemas, context);
            intermediateTypes.add(partialAggregationTypeComputer.getType((ILogicalExpression)((Object)aggFun), aggOpInputEnv, context.getMetadataProvider()));
        }
        int[] keyAndDecFields = new int[keys.length + fdColumns.length];
        for (i = 0; i < keys.length; ++i) {
            keyAndDecFields[i] = keys[i];
        }
        for (i = 0; i < fdColumns.length; ++i) {
            keyAndDecFields[keys.length + i] = fdColumns[i];
        }
        ArrayList<LogicalVariable> keyAndDecVariables = new ArrayList<LogicalVariable>();
        for (Pair<LogicalVariable, Mutable<ILogicalExpression>> p : gby.getGroupByList()) {
            keyAndDecVariables.add((LogicalVariable)p.first);
        }
        for (Pair<LogicalVariable, Mutable<ILogicalExpression>> p : gby.getDecorList()) {
            keyAndDecVariables.add(GroupByOperator.getDecorVariable(p));
        }
        for (LogicalVariable var : keyAndDecVariables) {
            aggOpInputEnv.setVarType(var, outputEnv.getVarType(var));
        }
        this.compileSubplans(inputSchemas[0], gby, opSchema, context);
        JobSpecification spec = builder.getJobSpec();
        IBinaryComparatorFactory[] compFactories = new IBinaryComparatorFactory[gbyCols.size()];
        IBinaryComparatorFactoryProvider bcfProvider = context.getBinaryComparatorFactoryProvider();
        i = 0;
        for (LogicalVariable v : gbyCols) {
            Object type = aggOpInputEnv.getVarType(v);
            compFactories[i] = this.orderColumns[i].getOrder() == OrderOperator.IOrder.OrderKind.ASC ? bcfProvider.getBinaryComparatorFactory(type, true) : bcfProvider.getBinaryComparatorFactory(type, false);
            ++i;
        }
        RecordDescriptor recordDescriptor = JobGenHelper.mkRecordDescriptor(context.getTypeEnvironment(op), opSchema, context);
        IAggregateEvaluatorFactory[] merges = new IAggregateEvaluatorFactory[n];
        ArrayList<LogicalVariable> usedVars = new ArrayList<LogicalVariable>();
        IOperatorSchema[] localInputSchemas = new IOperatorSchema[]{new OperatorSchemaImpl()};
        for (i = 0; i < n; ++i) {
            Iterator aggFun = (AggregateFunctionCallExpression)aggOp.getMergeExpressions().get(i).getValue();
            ((AbstractFunctionCallExpression)((Object)aggFun)).getUsedVariables(usedVars);
        }
        i = 0;
        for (Object e : intermediateTypes) {
            aggOpInputEnv.setVarType((LogicalVariable)usedVars.get(i++), e);
        }
        for (LogicalVariable logicalVariable : keyAndDecVariables) {
            localInputSchemas[0].addVariable(logicalVariable);
        }
        for (LogicalVariable logicalVariable : usedVars) {
            localInputSchemas[0].addVariable(logicalVariable);
        }
        for (i = 0; i < n; ++i) {
            AggregateFunctionCallExpression mergeFun = (AggregateFunctionCallExpression)aggOp.getMergeExpressions().get(i).getValue();
            merges[i] = expressionRuntimeProvider.createAggregateFunctionFactory(mergeFun, aggOpInputEnv, localInputSchemas, context);
        }
        RecordDescriptor partialAggRecordDescriptor = JobGenHelper.mkRecordDescriptor(context.getTypeEnvironment(op), localInputSchemas[0], context);
        SimpleAlgebricksAccumulatingAggregatorFactory simpleAlgebricksAccumulatingAggregatorFactory = new SimpleAlgebricksAccumulatingAggregatorFactory(aff, keyAndDecFields);
        simpleAlgebricksAccumulatingAggregatorFactory.setSourceLocation(gby.getSourceLocation());
        SimpleAlgebricksAccumulatingAggregatorFactory mergeFactory = new SimpleAlgebricksAccumulatingAggregatorFactory(merges, keyAndDecFields);
        mergeFactory.setSourceLocation(gby.getSourceLocation());
        INormalizedKeyComputerFactory normalizedKeyFactory = null;
        INormalizedKeyComputerFactoryProvider nkcfProvider = context.getNormalizedKeyComputerFactoryProvider();
        if (nkcfProvider == null) {
            normalizedKeyFactory = null;
        }
        Object type = aggOpInputEnv.getVarType(gbyCols.get(0));
        normalizedKeyFactory = this.orderColumns[0].getOrder() == OrderOperator.IOrder.OrderKind.ASC ? nkcfProvider.getNormalizedKeyComputerFactory(type, true) : nkcfProvider.getNormalizedKeyComputerFactory(type, false);
        int framesLimit = this.localMemoryRequirements.getMemoryBudgetInFrames();
        SortGroupByOperatorDescriptor gbyOpDesc = new SortGroupByOperatorDescriptor((IOperatorDescriptorRegistry)spec, framesLimit, keys, keyAndDecFields, normalizedKeyFactory, compFactories, (IAggregatorDescriptorFactory)simpleAlgebricksAccumulatingAggregatorFactory, (IAggregatorDescriptorFactory)mergeFactory, partialAggRecordDescriptor, recordDescriptor, false);
        gbyOpDesc.setSourceLocation(gby.getSourceLocation());
        this.contributeOpDesc(builder, gby, (IOperatorDescriptor)gbyOpDesc);
        ILogicalOperator src = (ILogicalOperator)op.getInputs().get(0).getValue();
        builder.contributeGraphEdge(src, 0, op, 0);
    }

    @Override
    public Pair<int[], int[]> getInputOutputDependencyLabels(ILogicalOperator op) {
        int[] inputDependencyLabels = new int[]{0};
        int[] outputDependencyLabels = new int[]{1};
        return new Pair((Object)inputDependencyLabels, (Object)outputDependencyLabels);
    }
}

