/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.runtime.operators.std;

import java.io.PrintStream;
import java.nio.ByteBuffer;
import org.apache.hyracks.algebricks.data.IAWriter;
import org.apache.hyracks.algebricks.runtime.operators.base.AbstractOneInputSinkPushRuntime;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;

public class SinkWriterRuntime
extends AbstractOneInputSinkPushRuntime {
    private final PrintStream printStream;
    private final IAWriter writer;
    private RecordDescriptor inputRecordDesc;
    private FrameTupleAccessor tAccess;
    private boolean autoClose = false;
    private boolean first = true;

    public SinkWriterRuntime(IAWriter writer, PrintStream printStream, RecordDescriptor inputRecordDesc) {
        this.writer = writer;
        this.printStream = printStream;
        this.inputRecordDesc = inputRecordDesc;
        this.tAccess = new FrameTupleAccessor(inputRecordDesc);
    }

    public SinkWriterRuntime(IAWriter writer, PrintStream printStream, RecordDescriptor inputRecordDesc, boolean autoClose) {
        this(writer, printStream, inputRecordDesc);
        this.autoClose = autoClose;
    }

    public void open() throws HyracksDataException {
        if (this.first) {
            this.first = false;
            this.tAccess = new FrameTupleAccessor(this.inputRecordDesc);
            this.writer.init();
        }
    }

    public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        this.tAccess.reset(buffer);
        int nTuple = this.tAccess.getTupleCount();
        for (int t = 0; t < nTuple; ++t) {
            this.writer.printTuple((IFrameTupleAccessor)this.tAccess, t);
        }
    }

    public void close() throws HyracksDataException {
        if (this.autoClose) {
            this.printStream.close();
        }
    }

    @Override
    public void setInputRecordDescriptor(int index, RecordDescriptor recordDescriptor) {
        this.inputRecordDesc = recordDescriptor;
    }

    public void fail() throws HyracksDataException {
    }

    public void flush() throws HyracksDataException {
    }
}

