/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.common.comm.io;

import java.nio.ByteBuffer;
import org.apache.hyracks.api.comm.FrameHelper;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.comm.IFrameTupleAppender;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.AbstractFrameAppender;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.util.IntSerDeUtils;

public class FrameTupleAppender
extends AbstractFrameAppender
implements IFrameTupleAppender {
    public FrameTupleAppender() {
    }

    public FrameTupleAppender(IFrame frame) throws HyracksDataException {
        this.reset(frame, true);
    }

    public FrameTupleAppender(IFrame frame, boolean clear) throws HyracksDataException {
        this.reset(frame, clear);
    }

    public boolean append(int[] fieldEndOffsets, byte[] bytes, int offset, int length) throws HyracksDataException {
        if (this.canHoldNewTuple(fieldEndOffsets.length, length)) {
            for (int i = 0; i < fieldEndOffsets.length; ++i) {
                IntSerDeUtils.putInt((byte[])this.array, (int)(this.tupleDataEndOffset + i * 4), (int)fieldEndOffsets[i]);
            }
            System.arraycopy(bytes, offset, this.array, this.tupleDataEndOffset + fieldEndOffsets.length * 4, length);
            this.tupleDataEndOffset += fieldEndOffsets.length * 4 + length;
            IntSerDeUtils.putInt((byte[])this.getBuffer().array(), (int)(FrameHelper.getTupleCountOffset((int)this.frame.getFrameSize()) - 4 * (this.tupleCount + 1)), (int)this.tupleDataEndOffset);
            ++this.tupleCount;
            IntSerDeUtils.putInt((byte[])this.getBuffer().array(), (int)FrameHelper.getTupleCountOffset((int)this.frame.getFrameSize()), (int)this.tupleCount);
            return true;
        }
        return false;
    }

    public boolean append(ITupleReference tuple) throws HyracksDataException {
        int i;
        int length = 0;
        for (i = 0; i < tuple.getFieldCount(); ++i) {
            length += tuple.getFieldLength(i);
        }
        if (this.canHoldNewTuple(tuple.getFieldCount(), length)) {
            length = 0;
            for (i = 0; i < tuple.getFieldCount(); ++i) {
                IntSerDeUtils.putInt((byte[])this.array, (int)(this.tupleDataEndOffset + i * 4), (int)(length += tuple.getFieldLength(i)));
            }
            length = 0;
            for (i = 0; i < tuple.getFieldCount(); ++i) {
                System.arraycopy(tuple.getFieldData(i), tuple.getFieldStart(i), this.array, this.tupleDataEndOffset + tuple.getFieldCount() * 4 + length, tuple.getFieldLength(i));
                length += tuple.getFieldLength(i);
            }
            this.tupleDataEndOffset += tuple.getFieldCount() * 4 + length;
            IntSerDeUtils.putInt((byte[])this.getBuffer().array(), (int)(FrameHelper.getTupleCountOffset((int)this.frame.getFrameSize()) - 4 * (this.tupleCount + 1)), (int)this.tupleDataEndOffset);
            ++this.tupleCount;
            IntSerDeUtils.putInt((byte[])this.getBuffer().array(), (int)FrameHelper.getTupleCountOffset((int)this.frame.getFrameSize()), (int)this.tupleCount);
            return true;
        }
        return false;
    }

    public boolean append(byte[] bytes, int offset, int length) throws HyracksDataException {
        if (this.canHoldNewTuple(0, length)) {
            System.arraycopy(bytes, offset, this.getBuffer().array(), this.tupleDataEndOffset, length);
            this.tupleDataEndOffset += length;
            IntSerDeUtils.putInt((byte[])this.array, (int)(FrameHelper.getTupleCountOffset((int)this.frame.getFrameSize()) - 4 * (this.tupleCount + 1)), (int)this.tupleDataEndOffset);
            ++this.tupleCount;
            IntSerDeUtils.putInt((byte[])this.array, (int)FrameHelper.getTupleCountOffset((int)this.frame.getFrameSize()), (int)this.tupleCount);
            return true;
        }
        return false;
    }

    public boolean appendSkipEmptyField(int[] fieldSlots, byte[] bytes, int offset, int length) throws HyracksDataException {
        if (this.canHoldNewTuple(fieldSlots.length, length)) {
            int effectiveSlots = 0;
            for (int i = 0; i < fieldSlots.length; ++i) {
                if (fieldSlots[i] <= 0) continue;
                IntSerDeUtils.putInt((byte[])this.array, (int)(this.tupleDataEndOffset + i * 4), (int)fieldSlots[i]);
                ++effectiveSlots;
            }
            System.arraycopy(bytes, offset, this.array, this.tupleDataEndOffset + effectiveSlots * 4, length);
            this.tupleDataEndOffset += effectiveSlots * 4 + length;
            IntSerDeUtils.putInt((byte[])this.array, (int)(FrameHelper.getTupleCountOffset((int)this.frame.getFrameSize()) - 4 * (this.tupleCount + 1)), (int)this.tupleDataEndOffset);
            ++this.tupleCount;
            IntSerDeUtils.putInt((byte[])this.array, (int)FrameHelper.getTupleCountOffset((int)this.frame.getFrameSize()), (int)this.tupleCount);
            return true;
        }
        return false;
    }

    public boolean append(IFrameTupleAccessor tupleAccessor, int tStartOffset, int tEndOffset) throws HyracksDataException {
        int length = tEndOffset - tStartOffset;
        if (this.canHoldNewTuple(0, length)) {
            ByteBuffer src = tupleAccessor.getBuffer();
            System.arraycopy(src.array(), tStartOffset, this.array, this.tupleDataEndOffset, length);
            this.tupleDataEndOffset += length;
            IntSerDeUtils.putInt((byte[])this.array, (int)(FrameHelper.getTupleCountOffset((int)this.frame.getFrameSize()) - 4 * (this.tupleCount + 1)), (int)this.tupleDataEndOffset);
            ++this.tupleCount;
            IntSerDeUtils.putInt((byte[])this.array, (int)FrameHelper.getTupleCountOffset((int)this.frame.getFrameSize()), (int)this.tupleCount);
            return true;
        }
        return false;
    }

    public boolean append(IFrameTupleAccessor tupleAccessor, int tIndex) throws HyracksDataException {
        int tStartOffset = tupleAccessor.getTupleStartOffset(tIndex);
        int tEndOffset = tupleAccessor.getTupleEndOffset(tIndex);
        return this.append(tupleAccessor, tStartOffset, tEndOffset);
    }

    public boolean appendConcat(IFrameTupleAccessor accessor0, int tIndex0, IFrameTupleAccessor accessor1, int tIndex1) throws HyracksDataException {
        int startOffset0 = accessor0.getTupleStartOffset(tIndex0);
        int endOffset0 = accessor0.getTupleEndOffset(tIndex0);
        int length0 = endOffset0 - startOffset0;
        int startOffset1 = accessor1.getTupleStartOffset(tIndex1);
        int endOffset1 = accessor1.getTupleEndOffset(tIndex1);
        int length1 = endOffset1 - startOffset1;
        if (this.canHoldNewTuple(0, length0 + length1)) {
            ByteBuffer src0 = accessor0.getBuffer();
            ByteBuffer src1 = accessor1.getBuffer();
            int slotsLen0 = accessor0.getFieldSlotsLength();
            int slotsLen1 = accessor1.getFieldSlotsLength();
            int dataLen0 = length0 - slotsLen0;
            int dataLen1 = length1 - slotsLen1;
            System.arraycopy(src0.array(), startOffset0, this.array, this.tupleDataEndOffset, slotsLen0);
            for (int i = 0; i < slotsLen1 / 4; ++i) {
                IntSerDeUtils.putInt((byte[])this.array, (int)(this.tupleDataEndOffset + slotsLen0 + i * 4), (int)(src1.getInt(startOffset1 + i * 4) + dataLen0));
            }
            System.arraycopy(src0.array(), startOffset0 + slotsLen0, this.array, this.tupleDataEndOffset + slotsLen0 + slotsLen1, dataLen0);
            System.arraycopy(src1.array(), startOffset1 + slotsLen1, this.array, this.tupleDataEndOffset + slotsLen0 + slotsLen1 + dataLen0, dataLen1);
            this.tupleDataEndOffset += length0 + length1;
            IntSerDeUtils.putInt((byte[])this.array, (int)(FrameHelper.getTupleCountOffset((int)this.frame.getFrameSize()) - 4 * (this.tupleCount + 1)), (int)this.tupleDataEndOffset);
            ++this.tupleCount;
            IntSerDeUtils.putInt((byte[])this.array, (int)FrameHelper.getTupleCountOffset((int)this.frame.getFrameSize()), (int)this.tupleCount);
            return true;
        }
        return false;
    }

    public boolean appendConcat(IFrameTupleAccessor accessor0, int tIndex0, int[] fieldSlots1, byte[] bytes1, int offset1, int dataLen1) throws HyracksDataException {
        int slotsLen1;
        int length1;
        int startOffset0 = accessor0.getTupleStartOffset(tIndex0);
        int endOffset0 = accessor0.getTupleEndOffset(tIndex0);
        int length0 = endOffset0 - startOffset0;
        if (this.canHoldNewTuple(0, length0 + (length1 = (slotsLen1 = fieldSlots1.length * 4) + dataLen1))) {
            ByteBuffer src0 = accessor0.getBuffer();
            int slotsLen0 = accessor0.getFieldSlotsLength();
            int dataLen0 = length0 - slotsLen0;
            System.arraycopy(src0.array(), startOffset0, this.array, this.tupleDataEndOffset, slotsLen0);
            for (int i = 0; i < fieldSlots1.length; ++i) {
                IntSerDeUtils.putInt((byte[])this.array, (int)(this.tupleDataEndOffset + slotsLen0 + i * 4), (int)(fieldSlots1[i] + dataLen0));
            }
            System.arraycopy(src0.array(), startOffset0 + slotsLen0, this.array, this.tupleDataEndOffset + slotsLen0 + slotsLen1, dataLen0);
            System.arraycopy(bytes1, offset1, this.array, this.tupleDataEndOffset + slotsLen0 + fieldSlots1.length * 4 + dataLen0, dataLen1);
            this.tupleDataEndOffset += length0 + length1;
            IntSerDeUtils.putInt((byte[])this.array, (int)(FrameHelper.getTupleCountOffset((int)this.frame.getFrameSize()) - 4 * (this.tupleCount + 1)), (int)this.tupleDataEndOffset);
            ++this.tupleCount;
            IntSerDeUtils.putInt((byte[])this.array, (int)FrameHelper.getTupleCountOffset((int)this.frame.getFrameSize()), (int)this.tupleCount);
            return true;
        }
        return false;
    }

    public boolean appendConcat(int[] fieldSlots0, byte[] bytes0, int offset0, int dataLen0, IFrameTupleAccessor accessor1, int tIndex1) throws HyracksDataException {
        int slotsLen0 = fieldSlots0.length * 4;
        int length0 = slotsLen0 + dataLen0;
        int startOffset1 = accessor1.getTupleStartOffset(tIndex1);
        int endOffset1 = accessor1.getTupleEndOffset(tIndex1);
        int length1 = endOffset1 - startOffset1;
        if (this.canHoldNewTuple(0, length0 + length1)) {
            int i;
            ByteBuffer src1 = accessor1.getBuffer();
            int slotsLen1 = accessor1.getFieldSlotsLength();
            int dataLen1 = length1 - slotsLen1;
            for (i = 0; i < fieldSlots0.length; ++i) {
                IntSerDeUtils.putInt((byte[])this.array, (int)(this.tupleDataEndOffset + i * 4), (int)fieldSlots0[i]);
            }
            for (i = 0; i < slotsLen1 / 4; ++i) {
                IntSerDeUtils.putInt((byte[])this.array, (int)(this.tupleDataEndOffset + slotsLen0 + i * 4), (int)(src1.getInt(startOffset1 + i * 4) + dataLen0));
            }
            System.arraycopy(bytes0, offset0, this.array, this.tupleDataEndOffset + slotsLen0 + slotsLen1, dataLen0);
            System.arraycopy(src1.array(), startOffset1 + slotsLen1, this.array, this.tupleDataEndOffset + slotsLen0 + slotsLen1 + dataLen0, dataLen1);
            this.tupleDataEndOffset += length0 + length1;
            IntSerDeUtils.putInt((byte[])this.array, (int)(FrameHelper.getTupleCountOffset((int)this.frame.getFrameSize()) - 4 * (this.tupleCount + 1)), (int)this.tupleDataEndOffset);
            ++this.tupleCount;
            IntSerDeUtils.putInt((byte[])this.array, (int)FrameHelper.getTupleCountOffset((int)this.frame.getFrameSize()), (int)this.tupleCount);
            return true;
        }
        return false;
    }

    public boolean appendProjection(IFrameTupleAccessor accessor, int tIndex, int[] fields) throws HyracksDataException {
        int fTargetSlotsLength;
        int length = fTargetSlotsLength = fields.length * 4;
        for (int i = 0; i < fields.length; ++i) {
            length += accessor.getFieldEndOffset(tIndex, fields[i]) - accessor.getFieldStartOffset(tIndex, fields[i]);
        }
        if (this.canHoldNewTuple(0, length)) {
            int fSrcSlotsLength = accessor.getFieldSlotsLength();
            int tStartOffset = accessor.getTupleStartOffset(tIndex);
            int fStartOffset = 0;
            int fEndOffset = 0;
            for (int i = 0; i < fields.length; ++i) {
                int fSrcStart = tStartOffset + fSrcSlotsLength + accessor.getFieldStartOffset(tIndex, fields[i]);
                int fLen = accessor.getFieldEndOffset(tIndex, fields[i]) - accessor.getFieldStartOffset(tIndex, fields[i]);
                System.arraycopy(accessor.getBuffer().array(), fSrcStart, this.array, this.tupleDataEndOffset + fTargetSlotsLength + fStartOffset, fLen);
                IntSerDeUtils.putInt((byte[])this.array, (int)(this.tupleDataEndOffset + i * 4), (int)(fEndOffset += fLen));
                fStartOffset = fEndOffset;
            }
            this.tupleDataEndOffset += length;
            IntSerDeUtils.putInt((byte[])this.array, (int)(FrameHelper.getTupleCountOffset((int)this.frame.getFrameSize()) - 4 * (this.tupleCount + 1)), (int)this.tupleDataEndOffset);
            ++this.tupleCount;
            IntSerDeUtils.putInt((byte[])this.array, (int)FrameHelper.getTupleCountOffset((int)this.frame.getFrameSize()), (int)this.tupleCount);
            return true;
        }
        return false;
    }
}

