/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record.reader.hdfs.parquet.converter.nested;

import java.io.IOException;
import org.apache.asterix.builders.IAsterixListBuilder;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.converter.IFieldValue;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.converter.ParquetConverterContext;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.converter.nested.AbstractComplexConverter;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.converter.nested.ObjectConverter;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.converter.primitve.PrimitiveConverterProvider;
import org.apache.asterix.om.pointables.base.DefaultOpenFieldType;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.parquet.io.api.PrimitiveConverter;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.PrimitiveType;

class ArrayConverter
extends AbstractComplexConverter {
    private IAsterixListBuilder builder;

    public ArrayConverter(AbstractComplexConverter parent, int index, GroupType parquetType, ParquetConverterContext context) {
        super(parent, index, parquetType, context);
    }

    public ArrayConverter(AbstractComplexConverter parent, IValueReference fieldName, int index, GroupType parquetType, ParquetConverterContext context) {
        super(parent, fieldName, index, parquetType, context);
    }

    public void start() {
        this.tempStorage = this.context.enterCollection();
        this.builder = this.context.getCollectionBuilder((AbstractCollectionType)DefaultOpenFieldType.NESTED_OPEN_AORDERED_LIST_TYPE);
    }

    public void end() {
        try {
            this.builder.write(this.getParentDataOutput(), true);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        this.addThisValueToParent();
        this.context.exitCollection(this.tempStorage, this.builder);
        this.tempStorage = null;
        this.builder = null;
    }

    @Override
    public void addValue(IFieldValue value) {
        try {
            this.builder.addItem((IValueReference)this.tempStorage);
        }
        catch (HyracksDataException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    protected PrimitiveConverter createAtomicConverter(GroupType type, int index) {
        PrimitiveType primitiveType = type.getType(index).asPrimitiveType();
        return PrimitiveConverterProvider.createPrimitiveConverter(primitiveType, this, index, this.context);
    }

    @Override
    protected ArrayConverter createArrayConverter(GroupType type, int index) {
        GroupType arrayType = type.getType(index).asGroupType();
        return new ArrayConverter(this, index, arrayType, this.context);
    }

    @Override
    protected ObjectConverter createObjectConverter(GroupType type, int index) {
        GroupType objectType = type.getType(index).asGroupType();
        return new ObjectConverter(this, index, objectType, this.context);
    }
}

