/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.rewriter.rules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractOperatorWithNestedPlans;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ProjectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnionAllOperator;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalExpressionReferenceTransform;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class RemoveRedundantVariablesRule
implements IAlgebraicRewriteRule {
    private final VariableSubstitutionVisitor substVisitor = new VariableSubstitutionVisitor();
    private final Map<LogicalVariable, List<LogicalVariable>> equivalentVarsMap = new HashMap<LogicalVariable, List<LogicalVariable>>();

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        if (context.checkIfInDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)opRef.getValue())) {
            return false;
        }
        this.clear();
        return this.removeRedundantVariables(opRef, true, context);
    }

    private void clear() {
        this.equivalentVarsMap.clear();
    }

    private void updateEquivalenceClassMap(LogicalVariable lhs, LogicalVariable rhs) {
        List<LogicalVariable> equivalentVars = this.equivalentVarsMap.get(rhs);
        if (equivalentVars == null) {
            equivalentVars = new ArrayList<LogicalVariable>();
            equivalentVars.add(rhs);
            equivalentVars.add(lhs);
            this.equivalentVarsMap.put(rhs, equivalentVars);
        }
        this.equivalentVarsMap.put(lhs, equivalentVars);
    }

    private LogicalVariable findEquivalentRepresentativeVar(LogicalVariable var) {
        List<LogicalVariable> equivalentVars = this.equivalentVarsMap.get(var);
        if (equivalentVars == null) {
            return null;
        }
        LogicalVariable representativeVar = equivalentVars.get(0);
        return var.equals((Object)representativeVar) ? null : representativeVar;
    }

    private boolean removeRedundantVariables(Mutable<ILogicalOperator> opRef, boolean first, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (!first) {
            context.addToDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)op);
        }
        LogicalOperatorTag opTag = op.getOperatorTag();
        boolean modified = false;
        for (Mutable inputOpRef : op.getInputs()) {
            if (!this.removeRedundantVariables((Mutable<ILogicalOperator>)inputOpRef, false, context)) continue;
            modified = true;
        }
        if (opTag == LogicalOperatorTag.ASSIGN) {
            AssignOperator assignOp = (AssignOperator)op;
            int numVars = assignOp.getVariables().size();
            for (int i = 0; i < numVars; ++i) {
                LogicalVariable lhs;
                ILogicalExpression expr = (ILogicalExpression)((Mutable)assignOp.getExpressions().get(i)).getValue();
                if (expr.getExpressionTag() != LogicalExpressionTag.VARIABLE || context.shouldNotBeInlined(lhs = (LogicalVariable)assignOp.getVariables().get(i))) continue;
                VariableReferenceExpression rhsVarRefExpr = (VariableReferenceExpression)expr;
                LogicalVariable rhs = rhsVarRefExpr.getVariableReference();
                this.updateEquivalenceClassMap(lhs, rhs);
            }
        }
        if (opTag == LogicalOperatorTag.PROJECT) {
            if (this.replaceProjectVars((ProjectOperator)op)) {
                modified = true;
            }
        } else if (op.getOperatorTag() == LogicalOperatorTag.UNIONALL) {
            if (this.replaceUnionAllVars((UnionAllOperator)op)) {
                modified = true;
            }
        } else if (op.acceptExpressionTransform((ILogicalExpressionReferenceTransform)this.substVisitor)) {
            modified = true;
        }
        if (op.hasNestedPlans()) {
            AbstractOperatorWithNestedPlans opWithNestedPlan = (AbstractOperatorWithNestedPlans)op;
            for (ILogicalPlan nestedPlan : opWithNestedPlan.getNestedPlans()) {
                for (Mutable rootRef : nestedPlan.getRoots()) {
                    if (!this.removeRedundantVariables((Mutable<ILogicalOperator>)rootRef, false, context)) continue;
                    modified = true;
                }
            }
        }
        if (opTag == LogicalOperatorTag.GROUP && this.handleGroupByVarRemapping((GroupByOperator)op)) {
            modified = true;
        }
        if (modified) {
            context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)op);
        }
        return modified;
    }

    private boolean handleGroupByVarRemapping(GroupByOperator groupOp) {
        boolean modified = false;
        block0: for (Pair gp : groupOp.getGroupByList()) {
            if (gp.first == null || ((ILogicalExpression)((Mutable)gp.second).getValue()).getExpressionTag() != LogicalExpressionTag.VARIABLE) continue;
            LogicalVariable groupByVar = ((VariableReferenceExpression)((Mutable)gp.second).getValue()).getVariableReference();
            Iterator iter = groupOp.getDecorList().iterator();
            while (iter.hasNext()) {
                LogicalVariable dv;
                Pair dp = (Pair)iter.next();
                if (dp.first != null || ((ILogicalExpression)((Mutable)dp.second).getValue()).getExpressionTag() != LogicalExpressionTag.VARIABLE || (dv = ((VariableReferenceExpression)((Mutable)dp.second).getValue()).getVariableReference()) != groupByVar) continue;
                List<LogicalVariable> equivalentVars = this.equivalentVarsMap.get(groupByVar);
                if (equivalentVars != null) {
                    equivalentVars.set(0, (LogicalVariable)gp.first);
                    this.equivalentVarsMap.put((LogicalVariable)gp.first, equivalentVars);
                } else {
                    this.updateEquivalenceClassMap((LogicalVariable)gp.first, groupByVar);
                }
                iter.remove();
                modified = true;
                continue block0;
            }
        }
        HashMap<LogicalVariable, LogicalVariable> variableToFirstDecorMap = new HashMap<LogicalVariable, LogicalVariable>();
        Iterator iter = groupOp.getDecorList().iterator();
        while (iter.hasNext()) {
            Pair dp = (Pair)iter.next();
            if (dp.first == null || ((ILogicalExpression)((Mutable)dp.second).getValue()).getExpressionTag() != LogicalExpressionTag.VARIABLE) continue;
            LogicalVariable dv = ((VariableReferenceExpression)((Mutable)dp.second).getValue()).getVariableReference();
            LogicalVariable firstDecor = (LogicalVariable)variableToFirstDecorMap.get(dv);
            if (firstDecor == null) {
                variableToFirstDecorMap.put(dv, (LogicalVariable)dp.first);
                continue;
            }
            this.updateEquivalenceClassMap((LogicalVariable)dp.first, firstDecor);
            iter.remove();
            modified = true;
        }
        return modified;
    }

    private boolean replaceProjectVars(ProjectOperator op) {
        List vars = op.getVariables();
        int size = vars.size();
        boolean modified = false;
        for (int i = 0; i < size; ++i) {
            LogicalVariable var = (LogicalVariable)vars.get(i);
            LogicalVariable representativeVar = this.findEquivalentRepresentativeVar(var);
            if (representativeVar == null) continue;
            vars.set(i, representativeVar);
            modified = true;
        }
        return modified;
    }

    private boolean replaceUnionAllVars(UnionAllOperator op) {
        boolean modified = false;
        for (Triple varMapping : op.getVariableMappings()) {
            LogicalVariable secondRepresentativeVar;
            LogicalVariable firstRepresentativeVar = this.findEquivalentRepresentativeVar((LogicalVariable)varMapping.first);
            if (firstRepresentativeVar != null) {
                varMapping.first = firstRepresentativeVar;
                modified = true;
            }
            if ((secondRepresentativeVar = this.findEquivalentRepresentativeVar((LogicalVariable)varMapping.second)) == null) continue;
            varMapping.second = secondRepresentativeVar;
            modified = true;
        }
        return modified;
    }

    private class VariableSubstitutionVisitor
    implements ILogicalExpressionReferenceTransform {
        private VariableSubstitutionVisitor() {
        }

        public boolean transform(Mutable<ILogicalExpression> exprRef) {
            ILogicalExpression e = (ILogicalExpression)exprRef.getValue();
            switch (e.getExpressionTag()) {
                case VARIABLE: {
                    VariableReferenceExpression varRefExpr = (VariableReferenceExpression)e;
                    LogicalVariable var = varRefExpr.getVariableReference();
                    LogicalVariable representative = RemoveRedundantVariablesRule.this.findEquivalentRepresentativeVar(var);
                    if (representative != null) {
                        varRefExpr.setVariable(representative);
                        return true;
                    }
                    return false;
                }
                case FUNCTION_CALL: {
                    AbstractFunctionCallExpression funcExpr = (AbstractFunctionCallExpression)e;
                    boolean modified = false;
                    for (Mutable arg : funcExpr.getArguments()) {
                        if (!this.transform((Mutable<ILogicalExpression>)arg)) continue;
                        modified = true;
                    }
                    return modified;
                }
            }
            return false;
        }
    }
}

