/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.jobgen.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.IHyracksJobBuilder;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractReplicateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IOperatorSchema;
import org.apache.hyracks.algebricks.core.jobgen.impl.ConnectorPolicyAssignmentPolicy;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobBuilder;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenContext;
import org.apache.hyracks.algebricks.core.jobgen.impl.OperatorSchemaImpl;
import org.apache.hyracks.api.dataflow.connectors.IConnectorPolicyAssignmentPolicy;
import org.apache.hyracks.api.job.IJobletEventListenerFactory;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.api.job.JobSpecification;

public class PlanCompiler {
    private JobGenContext context;
    private Map<Mutable<ILogicalOperator>, List<Mutable<ILogicalOperator>>> operatorVisitedToParents = new HashMap<Mutable<ILogicalOperator>, List<Mutable<ILogicalOperator>>>();

    public PlanCompiler(JobGenContext context) {
        this.context = context;
    }

    public JobGenContext getContext() {
        return this.context;
    }

    public JobSpecification compilePlan(ILogicalPlan plan, IJobletEventListenerFactory jobEventListenerFactory) throws AlgebricksException {
        return this.compilePlanImpl(plan, false, null, jobEventListenerFactory);
    }

    public JobSpecification compileNestedPlan(ILogicalPlan plan, IOperatorSchema outerPlanSchema) throws AlgebricksException {
        return this.compilePlanImpl(plan, true, outerPlanSchema, null);
    }

    private JobSpecification compilePlanImpl(ILogicalPlan plan, boolean isNestedPlan, IOperatorSchema outerPlanSchema, IJobletEventListenerFactory jobEventListenerFactory) throws AlgebricksException {
        JobSpecification spec = new JobSpecification(this.context.getFrameSize());
        spec.setMaxWarnings(this.context.getMaxWarnings());
        if (jobEventListenerFactory != null) {
            spec.setJobletEventListenerFactory(jobEventListenerFactory);
        }
        ArrayList<ILogicalOperator> rootOps = new ArrayList<ILogicalOperator>();
        JobBuilder builder = new JobBuilder(spec, this.context.getClusterLocations());
        for (Mutable<ILogicalOperator> opRef : plan.getRoots()) {
            this.compileOpRef(opRef, (IOperatorDescriptorRegistry)spec, builder, outerPlanSchema);
            rootOps.add((ILogicalOperator)opRef.getValue());
        }
        this.reviseEdges(builder);
        this.operatorVisitedToParents.clear();
        builder.buildSpec(rootOps);
        spec.setConnectorPolicyAssignmentPolicy((IConnectorPolicyAssignmentPolicy)new ConnectorPolicyAssignmentPolicy());
        spec.setUseConnectorPolicyForScheduling(false);
        if (isNestedPlan) {
            spec.setMetaOps(builder.getGeneratedMetaOps());
        }
        return spec;
    }

    private void compileOpRef(Mutable<ILogicalOperator> opRef, IOperatorDescriptorRegistry spec, IHyracksJobBuilder builder, IOperatorSchema outerPlanSchema) throws AlgebricksException {
        ILogicalOperator op = (ILogicalOperator)opRef.getValue();
        int n = op.getInputs().size();
        IOperatorSchema[] schemas = new IOperatorSchema[n];
        int i = 0;
        for (Mutable<ILogicalOperator> opChild : op.getInputs()) {
            List<Mutable<ILogicalOperator>> parents = this.operatorVisitedToParents.get(opChild);
            if (parents == null) {
                parents = new ArrayList<Mutable<ILogicalOperator>>();
                this.operatorVisitedToParents.put(opChild, parents);
                parents.add(opRef);
                this.compileOpRef(opChild, spec, builder, outerPlanSchema);
                schemas[i++] = this.context.getSchema((ILogicalOperator)opChild.getValue());
                continue;
            }
            if (!parents.contains(opRef)) {
                parents.add(opRef);
            }
            schemas[i++] = this.context.getSchema((ILogicalOperator)opChild.getValue());
        }
        OperatorSchemaImpl opSchema = new OperatorSchemaImpl();
        this.context.putSchema(op, opSchema);
        op.getVariablePropagationPolicy().propagateVariables(opSchema, schemas);
        op.contributeRuntimeOperator(builder, this.context, opSchema, schemas, outerPlanSchema);
    }

    private void reviseEdges(IHyracksJobBuilder builder) {
        this.operatorVisitedToParents.forEach((child, parents) -> {
            block4: {
                if (parents.size() <= 1 || ((ILogicalOperator)child.getValue()).getOperatorTag() != LogicalOperatorTag.REPLICATE && ((ILogicalOperator)child.getValue()).getOperatorTag() != LogicalOperatorTag.SPLIT) break block4;
                AbstractReplicateOperator rop = (AbstractReplicateOperator)child.getValue();
                if (rop.isBlocker()) {
                    List<Mutable<ILogicalOperator>> outputs = rop.getOutputs();
                    for (Mutable parent : parents) {
                        builder.contributeGraphEdge((ILogicalOperator)child.getValue(), outputs.indexOf(parent), (ILogicalOperator)parent.getValue(), 0);
                    }
                } else {
                    int i = 0;
                    for (Mutable parent : parents) {
                        builder.contributeGraphEdge((ILogicalOperator)child.getValue(), i, (ILogicalOperator)parent.getValue(), 0);
                        ++i;
                    }
                }
            }
        });
    }
}

