/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.aggregates.collections;

import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.runtime.aggregates.std.AbstractAggregateFunction;
import org.apache.hyracks.algebricks.runtime.base.IAggregateEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IAggregateEvaluatorFactory;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

class FirstElementEvalFactory
implements IAggregateEvaluatorFactory {
    private static final long serialVersionUID = 1L;
    private final IScalarEvaluatorFactory[] args;
    private final boolean isLocal;
    private final SourceLocation sourceLoc;

    FirstElementEvalFactory(IScalarEvaluatorFactory[] args, boolean isLocal, SourceLocation sourceLoc) {
        this.args = args;
        this.isLocal = isLocal;
        this.sourceLoc = sourceLoc;
    }

    public IAggregateEvaluator createAggregateEvaluator(final IEvaluatorContext ctx) throws HyracksDataException {
        return new AbstractAggregateFunction(this.sourceLoc){
            private boolean first;
            private ArrayBackedValueStorage outputVal;
            private IPointable inputVal;
            private IScalarEvaluator eval;
            private final byte[] nullBytes;
            private final byte[] systemNullBytes;
            {
                super(sourceLoc);
                this.first = true;
                this.outputVal = new ArrayBackedValueStorage();
                this.inputVal = new VoidPointable();
                this.eval = FirstElementEvalFactory.this.args[0].createScalarEvaluator(ctx);
                this.nullBytes = new byte[]{ATypeTag.SERIALIZED_NULL_TYPE_TAG};
                this.systemNullBytes = new byte[]{ATypeTag.SERIALIZED_SYSTEM_NULL_TYPE_TAG};
            }

            public void init() throws HyracksDataException {
                this.first = true;
            }

            public void step(IFrameTupleReference tuple) throws HyracksDataException {
                if (!this.first) {
                    return;
                }
                this.eval.evaluate(tuple, this.inputVal);
                byte typeTagByte = this.inputVal.getByteArray()[this.inputVal.getStartOffset()];
                if (typeTagByte == ATypeTag.SERIALIZED_SYSTEM_NULL_TYPE_TAG) {
                    return;
                }
                this.outputVal.assign((IValueReference)this.inputVal);
                this.first = false;
            }

            public void finish(IPointable result) throws HyracksDataException {
                if (this.first) {
                    result.set(FirstElementEvalFactory.this.isLocal ? this.systemNullBytes : this.nullBytes, 0, 1);
                    return;
                }
                result.set((IValueReference)this.outputVal);
            }

            public void finishPartial(IPointable result) throws HyracksDataException {
                this.finish(result);
            }
        };
    }
}

