/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.DataOutput;
import java.io.Serializable;
import org.apache.asterix.common.annotations.MissingNullInOutFunction;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AMutableInt32;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

@MissingNullInOutFunction
public class TreatAsIntegerDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new TreatAsIntegerDescriptor();
        }
    };

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(IEvaluatorContext ctx) throws HyracksDataException {
                final IScalarEvaluator inputEval = args[0].createScalarEvaluator(ctx);
                VoidPointable inputArg = new VoidPointable();
                ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
                DataOutput out = resultStorage.getDataOutput();
                AMutableInt32 aInt32 = new AMutableInt32(0);
                ISerializerDeserializer int32Ser = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT32);
                return new IScalarEvaluator((IPointable)inputArg, resultStorage, aInt32, int32Ser, out){
                    final /* synthetic */ IPointable val$inputArg;
                    final /* synthetic */ ArrayBackedValueStorage val$resultStorage;
                    final /* synthetic */ AMutableInt32 val$aInt32;
                    final /* synthetic */ ISerializerDeserializer val$int32Ser;
                    final /* synthetic */ DataOutput val$out;
                    {
                        this.val$inputArg = iPointable;
                        this.val$resultStorage = arrayBackedValueStorage;
                        this.val$aInt32 = aMutableInt32;
                        this.val$int32Ser = iSerializerDeserializer;
                        this.val$out = dataOutput;
                    }

                    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
                        int intValue;
                        inputEval.evaluate(tuple, this.val$inputArg);
                        if (PointableHelper.checkAndSetMissingOrNull(result, this.val$inputArg)) {
                            return;
                        }
                        byte[] bytes = this.val$inputArg.getByteArray();
                        int startOffset = this.val$inputArg.getStartOffset();
                        ATypeTag tt = ATypeTag.VALUE_TYPE_MAPPING[bytes[startOffset]];
                        switch (tt) {
                            case TINYINT: 
                            case SMALLINT: 
                            case INTEGER: 
                            case BIGINT: {
                                intValue = ATypeHierarchy.getIntegerValue((String)TreatAsIntegerDescriptor.this.getIdentifier().getName(), (int)0, (byte[])bytes, (int)startOffset, (boolean)true);
                                break;
                            }
                            case FLOAT: 
                            case DOUBLE: {
                                double doubleValue = ATypeHierarchy.getDoubleValue((String)TreatAsIntegerDescriptor.this.getIdentifier().getName(), (int)0, (byte[])bytes, (int)startOffset);
                                intValue = this.asInt(doubleValue);
                                break;
                            }
                            default: {
                                throw new TypeMismatchException(TreatAsIntegerDescriptor.this.sourceLoc, bytes[startOffset], ATypeTag.SERIALIZED_INT8_TYPE_TAG, ATypeTag.SERIALIZED_INT16_TYPE_TAG, ATypeTag.SERIALIZED_INT32_TYPE_TAG, ATypeTag.SERIALIZED_INT64_TYPE_TAG, ATypeTag.SERIALIZED_FLOAT_TYPE_TAG, ATypeTag.SERIALIZED_DOUBLE_TYPE_TAG);
                            }
                        }
                        this.val$resultStorage.reset();
                        this.val$aInt32.setValue(intValue);
                        this.val$int32Ser.serialize((Object)this.val$aInt32, this.val$out);
                        result.set((IValueReference)this.val$resultStorage);
                    }

                    private int asInt(double d) throws HyracksDataException {
                        long v;
                        if (Double.isFinite(d) && (double)(v = (long)d) == d && Integer.MIN_VALUE <= v && v <= Integer.MAX_VALUE) {
                            return (int)v;
                        }
                        throw new RuntimeDataException(39, TreatAsIntegerDescriptor.this.sourceLoc, new Serializable[]{Double.valueOf(d)});
                    }
                };
            }
        };
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.TREAT_AS_INTEGER;
    }
}

