/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.rewrites;

import java.util.HashMap;
import java.util.Map;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.expression.VariableExpr;

public class VariableSubstitutionEnvironment {
    private Map<String, Expression> oldVarToNewExpressionMap = new HashMap<String, Expression>();

    public VariableSubstitutionEnvironment() {
    }

    public VariableSubstitutionEnvironment(Map<VariableExpr, Expression> varExprMap) {
        varExprMap.forEach((key, value) -> this.oldVarToNewExpressionMap.put(key.getVar().getValue(), (Expression)value));
    }

    public VariableSubstitutionEnvironment(VariableSubstitutionEnvironment env) {
        this.oldVarToNewExpressionMap.putAll(env.oldVarToNewExpressionMap);
    }

    public void addMappings(Map<String, Expression> varExprMap) {
        this.oldVarToNewExpressionMap.putAll(varExprMap);
    }

    public Expression findSubstitution(VariableExpr oldVar) {
        return this.oldVarToNewExpressionMap.get(oldVar.getVar().getValue());
    }

    public boolean constainsOldVar(VariableExpr oldVar) {
        return this.oldVarToNewExpressionMap.containsKey(oldVar.getVar().getValue());
    }

    public void addSubstituion(VariableExpr oldVar, Expression newExpr) {
        this.oldVarToNewExpressionMap.put(oldVar.getVar().getValue(), newExpr);
    }

    public void removeSubstitution(VariableExpr oldVar) {
        if (oldVar == null) {
            return;
        }
        this.oldVarToNewExpressionMap.remove(oldVar.getVar().getValue());
    }

    public String toString() {
        return this.oldVarToNewExpressionMap.toString();
    }
}

