/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.rewriter.rules;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnionAllOperator;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorPropertiesUtil;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public final class RemoveRedundantVariablesInUnionRule
implements IAlgebraicRewriteRule {
    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) {
        return false;
    }

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        ILogicalOperator op = (ILogicalOperator)opRef.getValue();
        if (op.getOperatorTag() != LogicalOperatorTag.UNIONALL) {
            return false;
        }
        if (context.checkIfInDontApplySet((IAlgebraicRewriteRule)this, op)) {
            return false;
        }
        UnionAllOperator unionAllOp = (UnionAllOperator)op;
        ArrayList<LogicalVariable> newAssignVars = null;
        ArrayList<MutableObject> newAssignExprs = null;
        List varMappings = unionAllOp.getVariableMappings();
        int i = 0;
        while (i < varMappings.size()) {
            Triple varMapping = (Triple)varMappings.get(i);
            LogicalVariable existingOutputVar = RemoveRedundantVariablesInUnionRule.findVarMapping(varMappings, i, (LogicalVariable)varMapping.first, (LogicalVariable)varMapping.second);
            if (existingOutputVar != null) {
                LogicalVariable thisOutputVar = (LogicalVariable)varMapping.third;
                if (newAssignVars == null) {
                    newAssignVars = new ArrayList<LogicalVariable>();
                    newAssignExprs = new ArrayList<MutableObject>();
                }
                VariableReferenceExpression existingOutputVarRef = new VariableReferenceExpression(existingOutputVar);
                existingOutputVarRef.setSourceLocation(unionAllOp.getSourceLocation());
                newAssignVars.add(thisOutputVar);
                newAssignExprs.add(new MutableObject((Object)existingOutputVarRef));
                varMappings.remove(i);
                continue;
            }
            ++i;
        }
        if (newAssignVars == null) {
            return false;
        }
        AssignOperator newAssignOp = new AssignOperator(newAssignVars, newAssignExprs);
        newAssignOp.setSourceLocation(unionAllOp.getSourceLocation());
        newAssignOp.getInputs().add(new MutableObject((Object)unionAllOp));
        OperatorPropertiesUtil.markMovable((ILogicalOperator)newAssignOp, (boolean)false);
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)unionAllOp);
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)newAssignOp);
        opRef.setValue((Object)newAssignOp);
        context.addToDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)unionAllOp);
        return true;
    }

    private static LogicalVariable findVarMapping(List<Triple<LogicalVariable, LogicalVariable, LogicalVariable>> varMappings, int endIndexExclusive, LogicalVariable firstBranchVar, LogicalVariable secondBranchVar) {
        int n = Math.min(endIndexExclusive, varMappings.size());
        for (int i = 0; i < n; ++i) {
            Triple<LogicalVariable, LogicalVariable, LogicalVariable> t = varMappings.get(i);
            if (!((LogicalVariable)t.first).equals((Object)firstBranchVar) || !((LogicalVariable)t.second).equals((Object)secondBranchVar)) continue;
            return (LogicalVariable)t.third;
        }
        return null;
    }
}

