/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.impls;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.dataflow.common.utils.TaskUtil;
import org.apache.hyracks.dataflow.std.buffermanager.ISimpleFrameBufferManager;
import org.apache.hyracks.dataflow.std.buffermanager.SingleFrameBufferManager;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedListCursor;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedListTupleReference;
import org.apache.hyracks.storage.am.lsm.invertedindex.impls.AbstractInvertedListCursor;
import org.apache.hyracks.storage.am.lsm.invertedindex.util.InvertedIndexUtils;
import org.apache.hyracks.storage.common.IIndexCursorStats;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;
import org.apache.hyracks.storage.common.buffercache.ICachedPage;
import org.apache.hyracks.storage.common.file.BufferedFileHandle;

public abstract class AbstractOnDiskInvertedListCursor
extends AbstractInvertedListCursor {
    protected final IBufferCache bufferCache;
    protected final int fileId;
    public int currentElementIxForScan;
    protected int currentOffsetForScan;
    protected int currentPageIxForScan;
    protected int startPageId;
    protected int endPageId;
    protected int startOff;
    protected int numElements;
    protected int numPages;
    protected int bufferStartPageId;
    protected int bufferEndPageId;
    protected int bufferStartElementIx;
    protected int bufferNumLoadedPages;
    protected final IInvertedListTupleReference tuple;
    protected final ITypeTraits[] invListFields;
    protected ICachedPage page;
    protected final ISimpleFrameBufferManager bufferManagerForSearch;
    protected ArrayList<ByteBuffer> buffers;
    protected boolean moreBlocksToRead = true;
    protected int lastRandomSearchedElementIx;
    protected final IIndexCursorStats stats;

    protected AbstractOnDiskInvertedListCursor(IBufferCache bufferCache, int fileId, ITypeTraits[] invListFields, IHyracksTaskContext ctx, IIndexCursorStats stats) throws HyracksDataException {
        this(bufferCache, fileId, invListFields, ctx, stats, false);
    }

    protected AbstractOnDiskInvertedListCursor(IBufferCache bufferCache, int fileId, ITypeTraits[] invListFields, IIndexCursorStats stats) throws HyracksDataException {
        this(bufferCache, fileId, invListFields, null, stats, true);
    }

    protected AbstractOnDiskInvertedListCursor(IBufferCache bufferCache, int fileId, ITypeTraits[] invListFields, IHyracksTaskContext ctx, IIndexCursorStats stats, boolean isScan) throws HyracksDataException {
        this.bufferCache = bufferCache;
        this.fileId = fileId;
        this.currentElementIxForScan = 0;
        this.currentPageIxForScan = 0;
        this.bufferStartPageId = 0;
        this.bufferEndPageId = 0;
        this.bufferStartElementIx = 0;
        this.bufferNumLoadedPages = 0;
        this.lastRandomSearchedElementIx = 0;
        this.moreBlocksToRead = true;
        this.invListFields = invListFields;
        this.tuple = InvertedIndexUtils.createInvertedListTupleReference(invListFields);
        this.buffers = new ArrayList();
        if (ctx == null && !isScan) {
            throw HyracksDataException.create((int)110, (Serializable[])new Serializable[0]);
        }
        if (!isScan) {
            this.bufferManagerForSearch = (ISimpleFrameBufferManager)TaskUtil.get((String)"INVERTED_INDEX_SEARCH_FRAME_MANAGER", (IHyracksTaskContext)ctx);
            if (this.bufferManagerForSearch == null) {
                throw HyracksDataException.create((int)111, (Serializable[])new Serializable[0]);
            }
        } else {
            this.bufferManagerForSearch = new SingleFrameBufferManager();
        }
        this.stats = stats;
    }

    protected void allocateBuffers() throws HyracksDataException {
        ByteBuffer tmpBuffer;
        while ((tmpBuffer = this.bufferManagerForSearch.acquireFrame(this.bufferCache.getPageSize())) != null) {
            Arrays.fill(tmpBuffer.array(), (byte)0);
            this.buffers.add(tmpBuffer);
            if (this.buffers.size() < this.numPages) continue;
        }
        if (this.buffers.isEmpty()) {
            throw HyracksDataException.create((int)109, (Serializable[])new Serializable[]{AbstractOnDiskInvertedListCursor.class.getName()});
        }
    }

    protected void deallocateBuffers() throws HyracksDataException {
        for (int i = 0; i < this.buffers.size(); ++i) {
            this.bufferManagerForSearch.releaseFrame(this.buffers.get(i));
            this.buffers.set(i, null);
        }
        this.buffers.clear();
    }

    protected void clearBuffers() throws HyracksDataException {
        for (int i = 0; i < this.buffers.size(); ++i) {
            Arrays.fill(this.buffers.get(i).array(), (byte)0);
            this.buffers.get(i).clear();
        }
    }

    public boolean doHasNext() {
        return this.currentElementIxForScan < this.numElements;
    }

    @Override
    public void prepareLoadPages() throws HyracksDataException {
        this.clearBuffers();
        if (this.numPages > this.buffers.size()) {
            this.allocateBuffers();
        }
    }

    @Override
    public void loadPages() throws HyracksDataException {
        this.bufferStartPageId = this.bufferEndPageId + 1;
        int currentBufferIdx = 0;
        int i = this.bufferStartPageId;
        while (i <= this.endPageId) {
            this.page = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)i), false);
            this.stats.getPageCounter().update(1L);
            ByteBuffer tmpBuffer = this.page.getBuffer();
            System.arraycopy(tmpBuffer.array(), 0, this.buffers.get(currentBufferIdx).array(), 0, this.buffers.get(currentBufferIdx).capacity());
            this.buffers.get(currentBufferIdx).position(this.buffers.get(currentBufferIdx).capacity());
            this.bufferCache.unpin(this.page);
            this.bufferEndPageId = i++;
            if (++currentBufferIdx >= this.buffers.size()) break;
        }
        this.setBlockInfo();
    }

    @Override
    public void unloadPages() throws HyracksDataException {
        this.deallocateBuffers();
    }

    @Override
    protected void setInvListInfo(int startPageId, int endPageId, int startOff, int numElements) throws HyracksDataException {
        this.startPageId = startPageId;
        this.endPageId = endPageId;
        this.startOff = startOff;
        this.numElements = numElements;
        this.currentElementIxForScan = 0;
        this.currentPageIxForScan = 0;
        this.bufferStartPageId = startPageId;
        this.bufferEndPageId = startPageId - 1;
        this.moreBlocksToRead = true;
        this.numPages = endPageId - startPageId + 1;
        for (ByteBuffer buffer : this.buffers) {
            buffer.clear();
        }
    }

    protected void setBlockInfo() {
        this.bufferNumLoadedPages = this.bufferEndPageId - this.bufferStartPageId + 1;
        this.lastRandomSearchedElementIx = this.bufferStartElementIx;
        this.currentPageIxForScan = 0;
        if (this.bufferEndPageId == this.endPageId) {
            this.moreBlocksToRead = false;
        }
    }

    @Override
    public String printCurrentElement(ISerializerDeserializer[] serdes) throws HyracksDataException {
        StringBuilder strBuilder = new StringBuilder();
        for (int i = 0; i < this.tuple.getFieldCount(); ++i) {
            ByteArrayInputStream inStream = new ByteArrayInputStream(this.tuple.getFieldData(i), this.tuple.getFieldStart(i), this.tuple.getFieldLength(i));
            DataInputStream dataIn = new DataInputStream(inStream);
            Object o = serdes[i].deserialize((DataInput)dataIn);
            strBuilder.append(o.toString());
            if (i + 1 >= this.tuple.getFieldCount()) continue;
            strBuilder.append(",");
        }
        return strBuilder.toString();
    }

    @Override
    public int compareTo(IInvertedListCursor invListCursor) {
        try {
            return this.numElements - invListCursor.size();
        }
        catch (HyracksDataException hde) {
            throw new IllegalStateException(hde);
        }
    }

    @Override
    public int size() throws HyracksDataException {
        return this.numElements;
    }

    public ITupleReference doGetTuple() {
        return this.tuple;
    }

    public void doClose() throws HyracksDataException {
        if (!this.buffers.isEmpty()) {
            this.unloadPages();
        }
    }

    public void doDestroy() throws HyracksDataException {
        if (!this.buffers.isEmpty()) {
            this.unloadPages();
        }
    }
}

