/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.spi.NormalizedEndpointUri;
import org.apache.camel.support.PatternHelper;
import org.slf4j.MDC;

final class ProcessorHelper {
    private ProcessorHelper() {
    }

    static Object prepareRecipient(Exchange exchange, Object recipient) throws NoTypeConversionAvailableException {
        if (recipient instanceof Endpoint || recipient instanceof NormalizedEndpointUri) {
            return recipient;
        }
        if (recipient instanceof String) {
            String string = (String)recipient;
            recipient = string.trim();
        }
        if (recipient != null) {
            String string;
            CamelContext ecc = exchange.getContext();
            String uri = recipient instanceof String ? (string = (String)recipient) : (String)ecc.getTypeConverter().mandatoryConvertTo(String.class, exchange, recipient);
            return ecc.getCamelContextExtension().normalizeUri(uri);
        }
        return null;
    }

    static Endpoint getExistingEndpoint(Exchange exchange, Object recipient) {
        return ProcessorHelper.getExistingEndpoint(exchange.getContext(), recipient);
    }

    static Endpoint getExistingEndpoint(CamelContext context, Object recipient) {
        if (recipient instanceof Endpoint) {
            Endpoint endpoint = (Endpoint)recipient;
            return endpoint;
        }
        if (recipient != null) {
            if (recipient instanceof NormalizedEndpointUri) {
                NormalizedEndpointUri nu = (NormalizedEndpointUri)recipient;
                ExtendedCamelContext ecc = context.getCamelContextExtension();
                return ecc.hasEndpoint(nu);
            }
            String uri = recipient.toString();
            return context.hasEndpoint(uri);
        }
        return null;
    }

    static Runnable prepareMDCParallelTask(CamelContext camelContext, Runnable runnable) {
        Runnable answer = runnable;
        if (camelContext.isUseMDCLogging().booleanValue()) {
            String pattern = camelContext.getMDCLoggingKeysPattern();
            Map mdc = MDC.getCopyOfContextMap();
            if (mdc != null && !mdc.isEmpty()) {
                answer = () -> {
                    try {
                        if (pattern == null || "*".equals(pattern)) {
                            mdc.forEach(MDC::put);
                        } else {
                            String[] patterns = pattern.split(",");
                            mdc.forEach((k, v) -> {
                                if (PatternHelper.matchPatterns((String)k, (String[])patterns)) {
                                    MDC.put((String)k, (String)v);
                                }
                            });
                        }
                    }
                    finally {
                        runnable.run();
                    }
                };
            }
        }
        return answer;
    }
}

