//
// Latex Project Public Licence (lppl1.3) applies
// Originally written by Kwanleung Tse
// First Release : 1st July, 2014
// Last Update : 27th September, 2014
//
package worker4math.hktex2;

import java.util.ArrayList;
import android.util.SparseArray;
import android.util.SparseBooleanArray;

public final class Block {

	public static volatile SparseArray<ArrayList<String>> subblock = new SparseArray<ArrayList<String>>();
	public static volatile SparseArray<ArrayList<Float>> subblockwidth  = new SparseArray<ArrayList<Float>>();
	public static volatile SparseArray<ArrayList<Float>> subblockheight = new SparseArray<ArrayList<Float>>();
	public static volatile SparseArray<ArrayList<Float>> subblockdepth = new SparseArray<ArrayList<Float>>();
	public static volatile SparseArray<ArrayList<Float>> subblockxpos = new SparseArray<ArrayList<Float>>();
	public static volatile SparseArray<ArrayList<Float>> subblockypos = new SparseArray<ArrayList<Float>>(); 
	public static volatile SparseArray<ArrayList<String>> subblockattribute  = new SparseArray<ArrayList<String>>();

	public  static volatile SparseArray<ArrayList<Float>> blockwidth = new SparseArray<ArrayList<Float>>(); 
	public  static volatile SparseArray<ArrayList<Float>> blockheight = new SparseArray<ArrayList<Float>>();
	public  static volatile SparseArray<ArrayList<Float>> blockdepth = new SparseArray<ArrayList<Float>>();

	public static volatile SparseArray<ArrayList<String>> subblock2 = new SparseArray<ArrayList<String>>();
	public static volatile SparseArray<ArrayList<Float>> subblockxpos2 = new SparseArray<ArrayList<Float>>();
	public static volatile SparseArray<ArrayList<Float>> subblockypos2 = new SparseArray<ArrayList<Float>>(); 
	public static volatile SparseArray<ArrayList<String>> subblockattribute2 = new SparseArray<ArrayList<String>>();
	
	public static volatile SparseArray<Float> blockwidth2 = new SparseArray<Float>();
	public static volatile SparseArray<Float> blockheight2 = new SparseArray<Float>();
	public static volatile SparseArray<Float> blockdepth2 = new SparseArray<Float>();
	
	public static volatile SparseBooleanArray error = new SparseBooleanArray();
	public static volatile SparseArray<String> errormessage = new SparseArray<String>();
	
	public void initerror(int tid){
		error.put(tid, false);
		errormessage.put(tid, "");
		return;
	}
	
	public void result(int tid, int blocknumber, ArrayList<ArrayList<String>> sb, ArrayList<ArrayList<Float>> sbw, 
			ArrayList<ArrayList<Float>> sbh, ArrayList<ArrayList<Float>> sbd, ArrayList<ArrayList<Float>> sbx,
			ArrayList<ArrayList<Float>> sby, ArrayList<ArrayList<String>> sba, 
			ArrayList<Float> bw, ArrayList<Float> bh, ArrayList<Float> bd){

		int tid2=tid*100;
		synchronized(this){
		blockwidth.put(tid, new ArrayList<Float>());
		blockheight.put(tid, new ArrayList<Float>());
		blockdepth.put(tid, new ArrayList<Float>());
		
		for (int i=0;i<=blocknumber;i++){
			int index=tid2+i;
			subblock.put(index, new ArrayList<String>());
			subblockwidth.put(index, new ArrayList<Float>());
			subblockheight.put(index, new ArrayList<Float>());
			subblockdepth.put(index, new ArrayList<Float>());
			subblockxpos.put(index, new ArrayList<Float>());
			subblockypos.put(index, new ArrayList<Float>());
			subblockattribute.put(index, new ArrayList<String>());
			
			for (int ii=0;ii<=sb.get(i).size()-1;ii++){
				subblock.get(index).add(sb.get(i).get(ii));
				subblockwidth.get(index).add(sbw.get(i).get(ii));
				subblockheight.get(index).add(sbh.get(i).get(ii));
				subblockdepth.get(index).add(sbd.get(i).get(ii));
				subblockxpos.get(index).add(sbx.get(i).get(ii));
				subblockypos.get(index).add(sby.get(i).get(ii));
				subblockattribute.get(index).add(sba.get(i).get(ii));
			}			
			blockwidth.get(tid).add(bw.get(i));
			blockheight.get(tid).add(bh.get(i));
			blockdepth.get(tid).add(bd.get(i));
		}

		int l=subblock.get(tid2).size();	

		subblock2.put(tid, new ArrayList<String>());
        subblockxpos2.put(tid, new ArrayList<Float>());
        subblockypos2.put(tid, new ArrayList<Float>());
        subblockattribute2.put(tid, new ArrayList<String>());
        
		for (int i=0;i<=l-1;i++){
			if (!(subblock.get(tid2).get(i).equals("!dno ")) || i==0){
			subblock2.get(tid).add(subblock.get(tid2).get(i));
			subblockxpos2.get(tid).add(subblockxpos.get(tid2).get(i));
			subblockypos2.get(tid).add(subblockypos.get(tid2).get(i));
			subblockattribute2.get(tid).add(subblockattribute.get(tid2).get(i));
			}
		}
 
		blockwidth2.put(tid,blockwidth.get(tid).get(0));   
		blockheight2.put(tid,blockheight.get(tid).get(0));
		blockdepth2.put(tid,blockdepth.get(tid).get(0));
		
		error.put(tid, false);
		errormessage.put(tid, "");
		}
		}
	}