package com.dickimawbooks.jmakepdfx;

import java.net.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class MenuButtonItem
{
   public MenuButtonItem(String menuItemLabel, char menuItemMnemonic,
      URL imageLocation, String actionCommand,
      KeyStroke keyStroke, ActionListener listener,
      String toolTip, String altText)
   {
      item = new JMenuItem(menuItemLabel);
      item.setMnemonic(menuItemMnemonic);
      item.setActionCommand(actionCommand);

      button = new JButton();
      button.setActionCommand(actionCommand);

      if (listener != null)
      {
         item.addActionListener(listener);
         button.addActionListener(listener);
      }

      if (keyStroke != null)
      {
         item.setAccelerator(keyStroke);
      }

      if (toolTip != null)
      {
         item.setToolTipText(toolTip);
         button.setToolTipText(toolTip);
      }

      if (imageLocation != null)
      {
         button.setIcon(new ImageIcon(imageLocation,
            altText == null ? menuItemLabel : altText));
      }
   }

   public void setText(String text)
   {
      item.setText(text);
   }

   public String getText()
   {
      return item.getText();
   }

   public void setEnabled(boolean enable)
   {
/*
      item.setEnabled(enable);
      button.setEnabled(enable);
*/
      if (enable)
      {
         enableboth();
      }
      else
      {
         disableboth();
      }
   }

   private void enableboth()
   {
      Thread thread = new Thread()
      {
         public void run()
         {
            item.setEnabled(true);
            button.setEnabled(true);
         }
      };
      thread.start();
      thread = null;
   }

   private void disableboth()
   {
      Thread thread = new Thread()
      {
         public void run()
         {
            item.setEnabled(false);
            button.setEnabled(false);
         }
      };
      thread.start();
      thread = null;
   }

   public boolean isEnabled() 
   {
      return item.isEnabled();
   }

   public JMenuItem getItem()
   {
      return item;
   }

   public JButton getButton()
   {
      return button;
   }

   private JMenuItem item;
   private JButton button;
}
