/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Window;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;

public class DviMain
extends JFrame {
    private static ResourceBundle m_Resources;
    private static Properties m_Properties;
    private JTextArea m_Log;
    private File m_SelectedFile = null;
    private DviFontBase m_FontBase = null;
    private OpenFileListener m_Open = null;
    private ExitListener m_Exit = null;
    private PreferencesListener m_Preferences = null;
    private HelpAboutListener m_About = null;
    private Dimension m_PaperSize = new Dimension(612, 792);

    public static void main(String[] stringArray) {
        Object object;
        try {
            object = System.getProperty("java.version");
            if (((String)object).compareTo("1.1.2") < 0) {
                System.err.println("!!!WARNING: javaDVI must be run with a 1.1.2 or higher version Java Virtual Machine!!!");
                System.err.print("This Java Virtual Machine is version ");
                System.err.println((String)object);
                System.exit(1);
            }
        }
        catch (Throwable throwable) {
            System.err.println("Uncaught exception: " + throwable.getMessage());
            throwable.printStackTrace();
            System.exit(1);
        }
        DviMain.loadProperties();
        object = new DviMain();
        ((Window)object).addWindowListener(new WindowCloser((DviMain)object));
        ((Window)object).pack();
        ((Component)object).setVisible(true);
        System.out.println("args.length = " + stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            System.out.println("Arg[" + n + "] = " + stringArray[n]);
            File file = new File(stringArray[n]);
            if (file != null) {
                ((DviMain)object).setSelectedFile(file);
                DviFile dviFile = new DviFile((DviMain)object, file);
                dviFile.pack();
                ((Component)dviFile).setVisible(true);
            }
            ++n;
        }
    }

    public DviMain() {
        super("javaDVI");
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception exception) {
            System.err.println("Error loading Look & Feel: " + exception);
        }
        this.m_Log = new JTextArea(5, 40);
        this.m_Log.setMargin(new Insets(5, 5, 5, 5));
        this.m_Log.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.m_Log);
        this.createMenuBar();
        this.getContentPane().add((Component)jScrollPane, "Center");
    }

    public JTextArea getLog() {
        return this.m_Log;
    }

    public File getSelectedFile() {
        String string;
        if (this.m_SelectedFile == null && (string = m_Properties.getProperty("LastFile")) != null && string.length() > 0) {
            this.m_SelectedFile = new File(string);
        }
        return this.m_SelectedFile;
    }

    public void setSelectedFile(File file) {
        this.m_SelectedFile = file;
        if (!file.getAbsolutePath().equals(m_Properties.getProperty("LastFile"))) {
            m_Properties.setProperty("LastFile", file.getAbsolutePath());
        }
    }

    public DviFontBase getFontBase() {
        if (this.m_FontBase == null) {
            this.m_FontBase = new DviFontBase();
        }
        return this.m_FontBase;
    }

    private void createMenuBar() {
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)new DviMenuBar(this), "North");
    }

    public static String getResourceString(String string) {
        String string2 = m_Properties.getProperty(string);
        if (string2 == null) {
            try {
                string2 = m_Resources.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                string2 = null;
            }
        }
        return string2;
    }

    public OpenFileListener getOpenFileListener() {
        if (this.m_Open == null) {
            this.m_Open = new OpenFileListener(this);
        }
        return this.m_Open;
    }

    public ExitListener getExitListener() {
        if (this.m_Exit == null) {
            this.m_Exit = new ExitListener(this);
        }
        return this.m_Exit;
    }

    public PreferencesListener getPreferencesListener() {
        if (this.m_Preferences == null) {
            this.m_Preferences = new PreferencesListener(this);
        }
        return this.m_Preferences;
    }

    public HelpAboutListener getHelpAbout() {
        if (this.m_About == null) {
            this.m_About = new HelpAboutListener(this);
        }
        return this.m_About;
    }

    public void setProperty(String string, String string2) {
        m_Properties.setProperty(string, string2);
    }

    public void exit(int n) {
        String string = System.getProperty("user.home") + System.getProperty("file.separator") + "javaDVI.ini";
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            m_Properties.store(fileOutputStream, "javaDVI Initialization");
        }
        catch (IOException iOException) {
            System.err.println("javaDVI Exit error " + iOException.getMessage());
            iOException.printStackTrace();
        }
        System.exit(n);
    }

    public Dimension getPaperSize() {
        System.out.println("Paper size = " + this.m_PaperSize.getWidth() + " by " + this.m_PaperSize.getHeight() + " points.");
        return this.m_PaperSize;
    }

    public void setPaperSize(int n, int n2) {
        this.m_PaperSize.setSize(n, n2);
        System.out.println("Paper size set = " + this.m_PaperSize.getWidth() + " by " + this.m_PaperSize.getHeight() + " points.");
    }

    /*
     * Unable to fully structure code
     */
    private static void loadProperties() {
        block3: {
            DviMain.m_Properties = new Properties();
            try {
                var0 = System.getProperty("user.home") + System.getProperty("file.separator") + "javaDVI.ini";
                var1_2 = new FileInputStream(var0);
                DviMain.m_Properties.load(var1_2);
                break block3;
            }
            catch (IOException var0_1) {
                var1_3 = new String[]{"FontFile", "PrintDoubleSided", "PaperSizeDefault"};
                var2_4 = 0;
                ** while (var2_4 < var1_3.length)
            }
lbl-1000:
            // 1 sources

            {
                DviMain.m_Properties.setProperty(var1_3[var2_4], DviMain.m_Resources.getString(var1_3[var2_4]));
                ++var2_4;
                continue;
            }
        }
    }

    static {
        m_Properties = null;
        try {
            m_Resources = ResourceBundle.getBundle("javaDVI", Locale.getDefault());
        }
        catch (MissingResourceException missingResourceException) {
            System.err.println("javaDVI.properties not found");
            System.exit(1);
        }
    }
}

