% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extension.R
\docType{class}
\name{zarr_extension}
\alias{zarr_extension}
\title{Zarr extension support}
\description{
Many aspects of a Zarr array are implemented as extensions. More
precisely, all core properties of a Zarr array except for its shape are
defined as extension points, down to its data type. This class is the basic
ancestor for extensions. It supports generation of the appropriate metadata
for the extension, as well as processing in more specialized descendant
classes.

Extensions can be nested. For instance, a sharding object contains one or
more codecs, with both the sharding object and the codec being extension
points.
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{name}}{The name of the extension. Setting the name may be restricted
by descendant classes.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-zarr_extension-new}{\code{zarr_extension$new()}}
\item \href{#method-zarr_extension-metadata_fragment}{\code{zarr_extension$metadata_fragment()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-zarr_extension-new"></a>}}
\if{latex}{\out{\hypertarget{method-zarr_extension-new}{}}}
\subsection{Method \code{new()}}{
Create a new extension object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{zarr_extension$new(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{The name of the extension, a single character string.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An instance of this class.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-zarr_extension-metadata_fragment"></a>}}
\if{latex}{\out{\hypertarget{method-zarr_extension-metadata_fragment}{}}}
\subsection{Method \code{metadata_fragment()}}{
Return the metadata fragment that describes this extension
point object. This includes the metadata of any nested extension
objects.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{zarr_extension$metadata_fragment()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list with the metadata of this extension point object.
}
}
}
