% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dwt.R
\name{plot.dwt}
\alias{plot.dwt}
\title{Plot Discrete Wavelet Transform}
\usage{
\method{plot}{dwt}(x, index = NULL, couleur = NULL, ...)
}
\arguments{
\item{x}{A \code{dwt} object.}

\item{index}{A \code{vector} containing the indices to scales to be included in 
the graph. By default \code{index = 1:(min(c(J,4)))}, where \code{J} denotes the 
number of scales in \code{y}.}

\item{couleur}{A \code{vector} of colors of the same size as \code{index} used
for the different scales depicted in the graph. If \code{couleur} contains a single 
value the the same color will be used for all scales.}

\item{...}{additional arguments affecting the plot produced.}
}
\description{
Plots results of the dwt list in which additional parameters can be specified
}
\examples{
# Simulate a Gaussian white noise
n = 10^3
Xt = rnorm(n)

# dwt
Yt = dwt(Xt)

# Graph examples
plot(Yt)
plot(Yt, index = c(1,4,5,6,8,2))
plot(Yt, index = c(1,4,5,6), couleur = "blue")
plot(Yt, index = c(1,4,5,6), couleur = rep(c("blue","yellow"),2))
}
\author{
Justin Lee and Stephane Guerrier
}
\keyword{internal}
