% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_radar_imagery.R
\name{get_available_radar}
\alias{get_available_radar}
\title{Get a List of Available BOM Radar Imagery}
\usage{
get_available_radar(radar_id = "all")
}
\arguments{
\item{radar_id}{\code{Numeric}. \acronym{BOM} radar of interest for which a list
of available images will be returned.  Defaults to all images currently
available.}
}
\value{
A \code{\link[data.table:data.table]{data.table::data.table()}} of all selected \acronym{radar} locations with
location information and \var{product_ids}.
}
\description{
Fetch a listing of available \acronym{BOM} \acronym{radar} imagery from
\url{ftp://ftp.bom.gov.au/anon/gen/radar/} to determine which files are
currently available for download.  The files available are the most recent
\acronym{radar} imagery for each location, which are updated approximately
every 6 to 10 minutes by the \acronym{BOM}.  Ported from \pkg{bomrang}.
}
\details{
Valid \acronym{BOM} \acronym{radar} ID for each location required.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

# Check availability radar imagery for Wollongong (radar_id = 3)
imagery <- get_available_radar(radar_id = 3)

imagery
\dontshow{\}) # examplesIf}
}
\references{
Australian Bureau of Meteorology (BOM) radar image
\url{http://www.bom.gov.au/australia/radar/}.
}
\seealso{
Other BOM: 
\code{\link{find_forecast_towns}()},
\code{\link{get_ag_bulletin}()},
\code{\link{get_available_imagery}()},
\code{\link{get_coastal_forecast}()},
\code{\link{get_precis_forecast}()},
\code{\link{get_radar_imagery}()},
\code{\link{get_satellite_imagery}()},
\code{\link{parse_ag_bulletin}()},
\code{\link{parse_coastal_forecast}()},
\code{\link{parse_precis_forecast}()}

Other metadata: 
\code{\link{find_forecast_towns}()},
\code{\link{find_nearby_stations}()},
\code{\link{find_stations_in}()},
\code{\link{get_available_imagery}()},
\code{\link{get_dpird_availability}()},
\code{\link{get_stations_metadata}()}
}
\author{
Dean Marchiori, \email{deanmarchiori@gmail.com}, and Adam H. Sparks,
\email{adamhsparks@gmail.com}
}
\concept{BOM}
\concept{metadata}
