% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power2MixedContinuousBinary.R
\name{power2MixedContinuousBinary}
\alias{power2MixedContinuousBinary}
\title{Power Calculation for Two Co-Primary Mixed Endpoints}
\usage{
power2MixedContinuousBinary(
  n1,
  n2,
  delta,
  sd,
  p1,
  p2,
  rho,
  alpha,
  Test,
  nMC = 10000
)
}
\arguments{
\item{n1}{Sample size for group 1 (test group)}

\item{n2}{Sample size for group 2 (control group)}

\item{delta}{Mean difference for the continuous endpoint (group 1 - group 2)}

\item{sd}{Common standard deviation for the continuous endpoint}

\item{p1}{Probability of response in group 1 for the binary endpoint (0 < p1 < 1)}

\item{p2}{Probability of response in group 2 for the binary endpoint (0 < p2 < 1)}

\item{rho}{Biserial correlation between the latent continuous variable underlying
the binary endpoint and the observed continuous endpoint}

\item{alpha}{One-sided significance level (typically 0.025 or 0.05)}

\item{Test}{Statistical testing method for the binary endpoint. One of:
\itemize{
\item \code{"AN"}: Asymptotic normal method without continuity correction
\item \code{"ANc"}: Asymptotic normal method with continuity correction
\item \code{"AS"}: Arcsine method without continuity correction
\item \code{"ASc"}: Arcsine method with continuity correction
\item \code{"Fisher"}: Fisher's exact test (Monte Carlo simulation required)
}}

\item{nMC}{Number of Monte Carlo replications when Test = "Fisher" (default: 10000)}
}
\value{
A data frame with the following columns:
\item{n1}{Sample size for group 1}
\item{n2}{Sample size for group 2}
\item{delta}{Mean difference for continuous endpoint}
\item{sd}{Standard deviation for continuous endpoint}
\item{p1}{Response probability in group 1 for binary endpoint}
\item{p2}{Response probability in group 2 for binary endpoint}
\item{rho}{Biserial correlation}
\item{alpha}{One-sided significance level}
\item{Test}{Testing method used for binary endpoint}
\item{powerCont}{Power for the continuous endpoint alone}
\item{powerBin}{Power for the binary endpoint alone}
\item{powerCoprimary}{Power for both co-primary endpoints}
}
\description{
Calculates the power for a two-arm superiority trial with two co-primary
endpoints where one is continuous and one is binary, as described in
Sozu et al. (2012).
}
\details{
This function implements the power calculation for mixed endpoints (one continuous
and one binary) as described in Sozu et al. (2012). The method assumes that the
binary variable is derived from a latent continuous variable via dichotomization
at a threshold point.

\strong{For Fisher's exact test}, Monte Carlo simulation is used because exact calculation
is computationally intensive. The continuous endpoint is analyzed using t-test,
and the binary endpoint uses Fisher's exact test.

\strong{For asymptotic methods (AN, ANc, AS, ASc)}, analytical formulas are used based
on bivariate normal approximation. The correlation between test statistics depends
on the biserial correlation rho and the specific testing method.

\strong{Biserial Correlation:}
The biserial correlation rho represents the correlation between the latent continuous
variable underlying the binary endpoint and the observed continuous endpoint. This is
not the same as the point-biserial correlation observed in the data.
}
\examples{
# Power calculation using asymptotic normal method
power2MixedContinuousBinary(
  n1 = 100,
  n2 = 100,
  delta = 0.5,
  sd = 1,
  p1 = 0.6,
  p2 = 0.4,
  rho = 0.5,
  alpha = 0.025,
  Test = 'AN'
)

\donttest{
# Power calculation with Fisher's exact test (computationally intensive)
power2MixedContinuousBinary(
  n1 = 50,
  n2 = 50,
  delta = 0.5,
  sd = 1,
  p1 = 0.6,
  p2 = 0.4,
  rho = 0.5,
  alpha = 0.025,
  Test = 'Fisher',
  nMC = 5000
)
}

}
\references{
Sozu, T., Sugimoto, T., & Hamasaki, T. (2012). Sample size determination in
clinical trials with multiple co-primary endpoints including mixed continuous
and binary variables. \emph{Biometrical Journal}, 54(5), 716-729.
}
